// Edit.js del bloque hijo
import { __ } from '@wordpress/i18n';
import { InspectorControls, MediaUpload, RichText, MediaUploadCheck, useBlockProps } from '@wordpress/block-editor';
import { Button, Panel, PanelBody, PanelRow, TextControl } from "@wordpress/components";

import './editor.scss';

export default function Edit({ attributes, setAttributes }) {
	const { image, imageMobile, mediaType, video, title, text, icon, description } = attributes;

	return (
		<div {...useBlockProps()} className="splide__slide" data-icon={ icon } data-description={ description }>
			<InspectorControls key="setting">
				<Panel className="components-panel--custom">
					<PanelBody>
						<PanelRow>
							<MediaUpload
								allowedTypes={["image", "svg"]}
								onSelect={(media) => {
									setAttributes({ icon: media.url });
								}}
								multiple={false}
								render={({ open }) => (
									<>
										{image ? <img src={icon} /> : ""}
										<Button variant="primary" onClick={open}>
											{image === null
												? "Select media file"
												: "Select Icon"}
										</Button>
									</>
								)}
							/>
							<TextControl
								label="Description"
								value={description}
								onChange={(newValue) => setAttributes({ description: newValue })}
							/>
						</PanelRow>
					</PanelBody>
				</Panel>
			</InspectorControls>
			<figure className='no-mobile img-box'>
				<MediaUpload
					allowedTypes={['image', 'video']}
					onSelect={(media) => {
						if (media.type === 'image') {
							setAttributes({ image: media.url, mediaType: 'image', video: null });
						} else if (media.type === 'video') {
							setAttributes({ video: media.url, mediaType: 'video', image: null });
						}
					}}
					multiple={false}
					render={({ open }) => (
						<>
							{image && mediaType === 'image' ? (
								<>
									<img src={image} alt="Selected Image" />
									<Button className="bttn--danger" variant="danger" onClick={() => setAttributes({ image: null, mediaType: null, video: null })}>
										Remove Image
									</Button>
								</>
							) : video && mediaType === 'video' ? (
								<>
									<video controls width="300" height="200">
										<source src={video} type="video/mp4" />
										Your browser does not support the video tag.
									</video>
									<Button className="bttn--danger" variant="danger" onClick={() => setAttributes({ video: null, mediaType: null, image: null })}>
										Remove Video
									</Button>
								</>
							) : (
								<Button variant="primary" onClick={open}>
									Select Image or Video
								</Button>
							)}
						</>
					)}
				/>
			</figure>
			<figure className='mobile img-box'>
				<MediaUpload
					allowedTypes={['image']}
					onSelect={(media) => { setAttributes({ imageMobile: media.url }); }}
					multiple={false}
					render={({ open }) => (
						<>
							{image && imageMobile ? (
								<>
									<img src={imageMobile} />
									<Button className="bttn--danger" variant="danger" onClick={() => setAttributes({ imageMobile: null })}>Remove Image</Button>
								</>
							) : (
								<>
									<Button variant="primary" onClick={open}>Select Image Mobile</Button>
								</>
							)}
						</>
					)}
				/>
			</figure>
			<div className="txt-box">
				<div className="content">
					<RichText
						className="title"
						placeholder="Title..."
						tagName="h3"
						value={title}
						onChange={(newtitle) => setAttributes({ title: newtitle })}
					/>
					<RichText
						placeholder="Text..."
						tagName="p"
						value={text}
						onChange={(newtext) => setAttributes({ text: newtext })}
					/>
				</div>
			</div>
		</div>
	);
}
