import { useBlockProps } from '@wordpress/block-editor';

export default function save({ attributes }) {
	const { image, imageMobile, mediaType, video, title, text, icon, description } = attributes;

	return (
		<div {...useBlockProps.save()} className="splide__slide" data-icon={ icon } data-description={ description }>
				{mediaType === 'image' &&
				(<picture className="img-box">
					<source media="(min-width: 961px)" srcset={image} />
					<source media="(max-width: 960px) and (-webkit-min-device-pixel-ratio: 2)" srcset={imageMobile} />
					<img src={image || imageMobile} alt="" />
				</picture>)}
				{mediaType === 'video' && (
					<div className="img-box">
						<video playsInlineautoPlay muted loop playsInline>
							<source src={video} type="video/mp4" />
							Your browser does not support the video tag.
						</video>
					</div>
				)}
			<div className="txt-box">
				<div className="content">
					<h3 className="title">{title}</h3>
					{text && (<p>{text}</p>)}
				</div>
			</div>
		</div>
	);
}