/**
 * React hook that is used to mark the block wrapper element.
 * It provides all the necessary props like the class name.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/packages/packages-block-editor/#useblockprops
 */
import { InnerBlocks, useBlockProps } from '@wordpress/block-editor';

/**
 * The save function defines the way in which the different attributes should
 * be combined into the final markup, which is then serialized by the block
 * editor into `post_content`.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-edit-save/#save
 *
 * @return {Element} Element to render.
 */
export default function save(props) {
	const { attributes } = props;

	return (
		<section {...useBlockProps.save()} className="container icon-horizontal-slider" data-comp="icon-horizontal-slider">
			<div className="row full-width">
				<article className="col-12-11 offset-left-12-1 splide">
					<ul className="splide__pagination"></ul>
					<div className="splide__track">
						<div className="splide__list">
							<InnerBlocks.Content />
						</div>	
					</div>
				</article>
			</div>
		</section>
	);
}
