import { useBlockProps } from '@wordpress/block-editor';

export default function save({ attributes }) {
	const { image, mediaType, video } = attributes;

	return (
		<article {...useBlockProps.save()} className="splide__slide">
			<figure className="img-box">
				{mediaType === 'image' && <img src={image} alt="Selected Image" />}
				{mediaType === 'video' && (
					<video autoPlay playsInline muted loop>
						<source src={video} type="video/mp4" />
					</video>
				)}
			</figure>
		</article>
	);
}
