
import { __ } from '@wordpress/i18n';

import { MediaUpload, InspectorControls, useBlockProps, RichText } from '@wordpress/block-editor';
import { Button, Panel, PanelBody, PanelRow, TextControl } from '@wordpress/components';

import './editor.scss';

export default function Edit({ attributes, setAttributes }) {
	const { title, address, latLong, pin } = attributes;

	const onAddressChange = (newAddress) => {
		setAttributes({ address: newAddress });
	};

	const onLatLongChange = (newLatLong) => {
		setAttributes({ latLong: newLatLong });
	};

	return (
	<section {...useBlockProps()} className="container map-and-title" data-comp="map-and-title">
		<InspectorControls key='setting'>
			<Panel className="components-panel--custom">
				<PanelBody key="0" title="Settings">
					<PanelRow>
						<TextControl
							label="Address"
							value={address}
							onChange= {onAddressChange}
						/>
						<TextControl
							label="Latitude & Longitude"
							value={latLong}
							onChange= {onLatLongChange}
						/>
						<MediaUpload
							allowedTypes={['image']}
							onSelect={(media) => {
								setAttributes({ pin: media.url });
							}}
							multiple={false}
							render={({ open }) => (
								<>
									{pin ? <img src={pin} /> : ''}
									<Button variant="primary" onClick={open}>
										{pin === null
											? "Select Pin"
											: "Add Pin"}
									</Button>
								</>
							)}
						/>
					</PanelRow>
				</PanelBody>
			</Panel>
		</InspectorControls>

		<div className="row">
			<div className="col-12-12 center">
					<RichText
						placeholder="Enter title..."
						tagName="h2"
						value={title}
						onChange={(newTitle) => setAttributes({ title: newTitle })}
					/>
				<div className="map-container">
					<div id="map-title" className="map" data-latlong={attributes.latLong} data-address={attributes.address} data-pin={attributes.pin}></div>
				</div>
			</div>
		</div>
	</section>
	);
}