import { useBlockProps } from '@wordpress/block-editor';
export default function save(props) {
	const { attributes } = props;

	return (
	<section {...useBlockProps.save()} className="container map-and-title" data-comp="map-and-title">
		<div className="row">
			<div className="col-12-12 center">
				{attributes.title && (<h2>{attributes.title}</h2>)}
				<div className="map-container">
					<div id="map-title" className="map" data-latlong={attributes.latLong} data-address={attributes.address} data-pin={attributes.pin}></div>
				</div>
			</div>
		</div>
	</section>
	);
}
