
import { __ } from '@wordpress/i18n';
import './editor.scss';;

import { useBlockProps, RichText, MediaUpload } from '@wordpress/block-editor';
import { Button } from '@wordpress/components';

export default function Edit({ attributes, setAttributes }) {

	const { text, imageOne, imageTwo, imageThree, imageFour, imageFive, imageSix } = attributes;

	return (
		<section {...useBlockProps()} className="container paragraph-for-prices" data-comp="paragraph-for-prices">
			<header className="row">
				<div className="col-12-12 center">
					<RichText
						placeholder="Enter text here..."
						tagName="p"
						value={text}
						onChange={(newtext) => setAttributes({ text: newtext })}
					/>
				</div>
			</header>
			<section className="figures-container">
				<figure className="img-box figures-container__item">
					<MediaUpload
						onSelect={(media) => setAttributes({ imageOne: media.url })}
						allowedTypes={['image', 'image/svg+xml']}
						value={imageOne}
						render={({ open }) => (
							<>
								{imageOne ? (
									<>
										<img src={imageOne} />
										<div className='outer-control'>
											<Button className="bttn--danger" variant="danger" onClick={() => setAttributes({ imageOne: null })}>
												Remove image
											</Button>
										</div>
									</>
								) : (
									<div className='outer-control'>
										<Button variant="primary" onClick={open}>
											Select image
										</Button>
										<span className='image-sizes'>Recomended Size: 220 x 220</span>
									</div>
								)}
							</>
						)}
					/>
				</figure>
				<figure className="img-box figures-container__item">
					<MediaUpload
						onSelect={(media) => setAttributes({ imageTwo: media.url })}
						allowedTypes={['image', 'image/svg+xml']}
						value={imageTwo}
						render={({ open }) => (
							<>
								{imageTwo ? (
									<>
										<img src={imageTwo} />
										<div className='outer-control'>
											<Button className="bttn--danger" variant="danger" onClick={() => setAttributes({ imageTwo: null })}>
												Remove image
											</Button>
										</div>
									</>
								) : (
									<div className='outer-control'>
										<Button variant="primary" onClick={open}>
											Select image
										</Button>
										<span className='image-sizes'>Recomended Size: 220 x 220</span>
									</div>
								)}
							</>
						)}
					/>
				</figure>
				<figure className="img-box figures-container__item">
					<MediaUpload
						onSelect={(media) => setAttributes({ imageThree: media.url })}
						allowedTypes={['image', 'image/svg+xml']}
						value={imageThree}
						render={({ open }) => (
							<>
								{imageThree ? (
									<>
										<img src={imageThree} />
										<div className='outer-control'>
											<Button className="bttn--danger" variant="danger" onClick={() => setAttributes({ imageThree: null })}>
												Remove image
											</Button>
										</div>
									</>
								) : (
									<div className='outer-control'>
										<Button variant="primary" onClick={open}>
											Select image
										</Button>
										<span className='image-sizes'>Recomended Size: 220 x 220</span>
									</div>
								)}
							</>
						)}
					/>
				</figure>
				<figure className="img-box figures-container__item">
					<MediaUpload
						onSelect={(media) => setAttributes({ imageFour: media.url })}
						allowedTypes={['image', 'image/svg+xml']}
						value={imageFour}
						render={({ open }) => (
							<>
								{imageFour ? (
									<>
										<img src={imageFour} />
										<div className='outer-control'>
											<Button className="bttn--danger" variant="danger" onClick={() => setAttributes({ imageFour: null })}>
												Remove image
											</Button>
										</div>
									</>
								) : (
									<div className='outer-control'>
										<Button variant="primary" onClick={open}>
											Select image
										</Button>
										<span className='image-sizes'>Recomended Size: 220 x 220</span>
									</div>
								)}
							</>
						)}
					/>
				</figure>
				<figure className="img-box figures-container__item">
					<MediaUpload
						onSelect={(media) => setAttributes({ imageFive: media.url })}
						allowedTypes={['image', 'image/svg+xml']}
						value={imageFive}
						render={({ open }) => (
							<>
								{imageFive ? (
									<>
										<img src={imageFive} />
										<div className='outer-control'>
											<Button className="bttn--danger" variant="danger" onClick={() => setAttributes({ imageFive: null })}>
												Remove image
											</Button>
										</div>
									</>
								) : (
									<div className='outer-control'>
										<Button variant="primary" onClick={open}>
											Select image
										</Button>
										<span className='image-sizes'>Recomended Size: 220 x 220</span>
									</div>
								)}
							</>
						)}
					/>
				</figure>
				<figure className="img-box figures-container__item no-mobile">
					<MediaUpload
						onSelect={(media) => setAttributes({ imageSix: media.url })}
						allowedTypes={['image', 'image/svg+xml']}
						value={imageSix}
						render={({ open }) => (
							<>
								{imageSix ? (
									<>
										<img src={imageSix} />
										<div className='outer-control'>
											<Button className="bttn--danger" variant="danger" onClick={() => setAttributes({ imageSix: null })}>
												Remove image
											</Button>
										</div>
									</>
								) : (
									<div className='outer-control'>
										<Button variant="primary" onClick={open}>
											Select image
										</Button>
										<span className='image-sizes'>Recomended Size: 220 x 220</span>
									</div>
								)}
							</>
						)}
					/>
				</figure>
			</section>
		</section>
	);
}



