
import { useBlockProps, RichText } from '@wordpress/block-editor';
export default function save(props) {
	const { attributes } = props;
	return (
		<section {...useBlockProps.save()} className="container paragraph-for-prices" data-comp="paragraph-for-prices">
			<header className="row">
				<div className="col-12-12 center">
                    {attributes.text && <RichText.Content tagName='p' value={attributes.text}/>}
				</div>
			</header>
			<section className="figures-container">
				<figure className="img-box figures-container__item">
					{attributes.imageOne && (<img src={attributes.imageOne} alt="" />)}
				</figure>
				<figure className="img-box figures-container__item">
					{attributes.imageTwo && (<img src={attributes.imageTwo} alt="" />)}
				</figure>
				<figure className="img-box figures-container__item">
					{attributes.imageThree && (<img src={attributes.imageThree} alt="" />)}
				</figure>
				<figure className="img-box figures-container__item">
					{attributes.imageFour && (<img src={attributes.imageFour} alt="" />)}
				</figure>
				<figure className="img-box figures-container__item">
					{attributes.imageFive && (<img src={attributes.imageFive} alt="" />)}
				</figure>
				<figure className="img-box figures-container__item no-mobile">
					{attributes.imageSix && (<img src={attributes.imageSix} alt="" />)}
				</figure>
			</section>
		</section>
	);
}
