import { __ } from "@wordpress/i18n";
import {
	MediaUpload,
	RichText,
	useBlockProps,
	InspectorControls,
} from "@wordpress/block-editor";
import { Button, Panel, PanelBody, PanelRow } from "@wordpress/components";
import ResponsiveMedia from "./modules/ResponsiveMedia";
import preview from './assets/side-by-side-image-video-container.jpg';
export default function Edit({ attributes, setAttributes }) {
	const {
		title,
		leftText,
		leftResponsive,
		rightText,
		rightResponsive,
		image,
		video,
	} = attributes;

	return (
		<>
			<InspectorControls key="setting">
				<Panel className="components-panel--custom">
					<PanelBody>
						<ResponsiveMedia.control
							title="Media Left"
							name="leftResponsive"
							attribute={leftResponsive}
							setAttributes={setAttributes}
						/>
						<ResponsiveMedia.control
							title="Media Right"
							name="rightResponsive"
							attribute={rightResponsive}
							setAttributes={setAttributes}
						/>
					</PanelBody>
				</Panel>
			</InspectorControls>
			<section
				{...useBlockProps()}
				className="side-by-side-image-video container block-editor-block-list__block wp-block"
				data-comp="side-by-side-image-video" data-preview="true"
			>

				<figure className="preview">
					<img src={preview} alt="" />
				</figure>

				<header className="row center">
					<RichText
						placeholder="Enter title here..."
						tagName="h2"
						value={title}
						onChange={(newtitle) => setAttributes({ title: newtitle })}
						className="center col-12-10"
					/>
				</header>
				<div className="row full-width middle">
					<article className="left-side" data-target="left">
						<aside className="img-box video-box">
							<ResponsiveMedia.edit attribute={leftResponsive} />
						</aside>
						<header>
							<RichText
								placeholder="Enter left text here..."
								tagName="h3"
								value={leftText}
								onChange={(val) => setAttributes({ leftText: val })}
							/>
						</header>
					</article>
					<article className="right-side" data-target="right">
						<aside className="img-box video-box">
							<ResponsiveMedia.edit attribute={rightResponsive} />
						</aside>
						<header>
							<RichText
								placeholder="Enter right text here..."
								tagName="h3"
								value={rightText}
								onChange={(val) => setAttributes({ rightText: val })}
							/>
						</header>
					</article>
				</div>
			</section>
		</>
	);
}
