import { RichText, useBlockProps } from "@wordpress/block-editor";
import ResponsiveMedia from "./modules/ResponsiveMedia";
export default function save({ attributes }) {
	const { title, leftText, leftResponsive, rightText, rightResponsive } =
		attributes;

	return (
		<section
			{...useBlockProps.save()}
			className="side-by-side-image-video container"
			data-comp="side-by-side-image-video"
		>
			<header className="row center">
				{title && (
					<RichText.Content tagName="h2" className="center col-12-10" value={title} />
				)}
			</header>
			<div className="row full-width middle">
				<article className="left-side" data-target="left" data-element="video-container">
					<aside className="img-box">
						<ResponsiveMedia.view attribute={leftResponsive} />
					</aside>
					<header>
						{leftText && <RichText.Content tagName="h3" value={leftText} />}
					</header>
				</article>
				<article className="right-side" data-target="right" data-element="video-container">
					<aside className="video-box">
						<ResponsiveMedia.view attribute={rightResponsive} />
					</aside>
					<header>
						{rightText && <RichText.Content tagName="h3" value={rightText} />}
					</header>
				</article>
			</div>
		</section>
	);
}
