
import memoize from 'memize';
import times from 'lodash/times';
import { __ } from '@wordpress/i18n';
import { ButtonBlockAppender, InnerBlocks, useBlockProps } from '@wordpress/block-editor';
import './editor.scss';
import { useSelect } from '@wordpress/data';




const ALLOWED_BLOCKS = [ 'nihi/slider-header-autoplay-item' ];
const getCount = memoize( ( count ) => {
	return times( count, () => [ 'nihi/slider-header-autoplay-item' ] );
} );

export default function Edit({ attributes, setAttributes, clientId }) {
	const { count } = attributes;
	const { deviceType } = useSelect(select => ({ deviceType: select('core/edit-post').__experimentalGetPreviewDeviceType() }), []);


	return (
		<section  {...useBlockProps()} className={`slider-header-autoplay container slider-editor ${deviceType}`} data-comp="sliderHeaderAutoplay">
			
				<div className="row full-width">
					<div className="col-12-12 splide">
						<div className="splide__track">
							<ul className="splide__list">
								<InnerBlocks
									__experimentalCaptureToolbars={ true }
									allowedBlocks={ ALLOWED_BLOCKS }
									template={ getCount( count ) }
								/>
								<ButtonBlockAppender rootClientId={ clientId } />
						</ul>
					</div>
				</div>
			</div>
		</section>
	);
}