// Edit.js del bloque hijo
import { __ } from '@wordpress/i18n';
import { MediaUpload, InnerBlocks, MediaUploadCheck, useBlockProps } from '@wordpress/block-editor';
import { Button } from '@wordpress/components';

import './editor.scss';

export default function Edit({ attributes, setAttributes }) {
	const { image, imageMobile, mediaType, video } = attributes;

	return (
		<li {...useBlockProps()} className="splide__slide">
			<aside className="img-box">
				<div className='no-mobile img-box'>
					<MediaUpload
						allowedTypes={['image', 'video']}
						onSelect={(media) => {
							if (media.type === 'image') {
								setAttributes({ image: media.url, mediaType: 'image', video: null });
							} else if (media.type === 'video') {
								setAttributes({ video: media.url, mediaType: 'video', image: null });
							}
						}}
						multiple={false}
						render={({ open }) => (
							<>
								{image && mediaType === 'image' ? (
									<>
										<img src={image} alt="Selected Image" />
										<div className='outer-control'>
										<Button className="bttn--danger" variant="danger" onClick={() => setAttributes({ image: null, mediaType: null, video: null })}>
											Remove Image
										</Button>
										</div>
									</>
								) : video && mediaType === 'video' ? (
									<>
											<video playsInline controls >
											<source src={video} type="video/mp4" />
											Your browser does not support the video tag.
										</video>
										<div className='outer-control'>
											<Button className="bttn--danger" variant="danger" onClick={() => setAttributes({ video: null, mediaType: null, image: null })}>
												Remove Video
											</Button>
										</div>
									</>
								) : (
									<div className='outer-control'>
										<Button variant="primary" onClick={open}>
											Select Image or Video
										</Button>
										<span>Recomended size: 1080 x 720</span>
									</div>
								)}
							</>
						)}
					/>
				</div>
				<div className='mobile img-box'>  
					<MediaUpload
						allowedTypes={['image']}
						onSelect={ (media) => { setAttributes({ imageMobile: media.url });} }
						multiple={false}
						render={({ open }) => (
							<>
								{ image && imageMobile ? (
									<>
										<img src={imageMobile} />
										<div className='outer-control'>
											<Button className="bttn--danger" variant="danger" onClick={() => setAttributes({ imageMobile: null })}>Remove Image</Button>
										</div>	
									</>
								) : (
									<div className='outer-control'>
										<Button variant="primary" onClick={open}>Select Image Mobile</Button>
											<span>Recomended size: 340 x 480</span>
									</div>	
								)}
							</>
						)}
					/>
				</div>
			</aside>
			<header>
				<InnerBlocks
					allowedBlocks={['core/heading']}
					template={[
						['core/heading', { level: 2, placeholder: 'Texto' }],
					]}
				/>
			</header>
		</li>
	);
}
