import { useBlockProps, InnerBlocks } from '@wordpress/block-editor';


export default function save({ attributes }) {
	const { image, imageMobile, mediaType, video } = attributes;

	return (
		<li {...useBlockProps.save()} className="splide__slide">
			<aside className="img-box">
				{mediaType === 'image' && 
					(<picture className="img-box">
						<source media="(min-width: 961px)" srcset={image} />
						<source media="(max-width: 960px) and (-webkit-min-device-pixel-ratio: 2)" srcset={imageMobile} />
						<img src={image || imageMobile} alt="" />
					</picture>)}
				{mediaType === 'video' && (
					<video autoPlay muted loop playsInline>
						<source src={video} type="video/mp4" />
						Your browser does not support the video tag.
					</video>
				)}
			</aside>
			<header>
				<InnerBlocks.Content />
			</header>
		</li>
	);
}

