import { __ } from '@wordpress/i18n';
import { InspectorControls, useBlockProps, RichText } from '@wordpress/block-editor';
import { CheckboxControl, Panel, PanelBody, PanelRow, TextControl } from '@wordpress/components';
import './editor.scss';

export default function Edit({ attributes, setAttributes }) {
	const { title, subtitle, cta } = attributes;

	const onButtonUpdate = (value, type) => {
		const { link, title, target } = attributes.cta;

		const updatedCta = {
			...attributes.cta,
			[type === 'link' ? 'link' : type === 'title' ? 'title' : 'target']: value,
		};

		setAttributes({ cta: updatedCta });
	};

	return (
		<section { ...useBlockProps() } className='container small-macro-text-with-button' data-comp='small-macro-text-with-button'>
			
			<InspectorControls key='setting'>
				<Panel className="components-panel--custom">
					<PanelBody key="0" title="Settings">
						<PanelRow>
							<TextControl
								label="CTA Link"
								value={Object.keys(cta).length > 0 ? cta.link : ''}
								onChange={(val) => onButtonUpdate(val, 'link')}
							/>
							<TextControl
								label="CTA Text"
								value={Object.keys(cta).length > 0 ? cta.title : ''}
								onChange={(val) => onButtonUpdate(val, 'title')}
							/>
							<CheckboxControl
								label="Open in new tab?"
								help="Link open in new tab"
								checked={Object.keys(cta).length > 0 ? cta.target : 0}
								onChange={(val) => onButtonUpdate(val, 'target')}
							/>
						</PanelRow>
					</PanelBody>
				</Panel>
			</InspectorControls>
			<div className="row">
				<div className="col-12-12 center">
					<hr />
					<RichText
						placeholder="Enter text here..."
						tagName="h3"
						value={subtitle}
						onChange={(newsubtitle) => setAttributes({ subtitle: newsubtitle })}
					/>
					
					<RichText
						placeholder="Enter title here..."
						tagName="h2"
						value={title}
						onChange={(newtitle) => setAttributes({ title: newtitle })}
					/>
					{cta.link && cta.title ? (<a href={cta.link} className="button" target={(attributes.cta.target) ? '_blank' : '_self'} rel="noopener">{cta.title}</a>) : null }
					<hr className="big" />
				</div>
			</div>
		</section>
	);
}
