import { useBlockProps } from '@wordpress/block-editor';
export default function save(props) {
	const { attributes } = props;
	
	return (
		<section  {...useBlockProps.save()} className="container small-macro-text-with-button" data-comp="small-macro-text-with-button">
			<div className="row">
				<div className="col-12-12 center">
					<hr />
					{attributes.subtitle && (<h3>{attributes.subtitle}</h3>)}
					{attributes.title && (<h2>{attributes.title}</h2>)}
					{attributes.cta.link && attributes.cta.title ? (<a href={attributes.cta.link} className="button" target={(attributes.cta.target) ? '_blank' : '_self'} rel="noopener">{attributes.cta.title}</a>) : null}
					<hr className="big" />
				</div>
			</div>
		</section>
	);
}
