import { __ } from '@wordpress/i18n';
import {  useBlockProps } from '@wordpress/block-editor';
import { InspectorControls } from '@wordpress/block-editor';
import { Panel, PanelBody, PanelRow, TextControl } from '@wordpress/components';

import './editor.scss';

export default function Edit({ attributes, setAttributes }) {
	const { heightDesktop, heightMobile } = attributes;

	return (
		<>
			<InspectorControls key='setting'>
				<Panel className="components-panel--custom">
					<PanelBody key="0" title="Settings">
						<PanelRow>
							<TextControl
								label="Height desktop"
								value={heightDesktop}
								onChange={(val) => setAttributes({ heightDesktop: val })}
							/>
							<TextControl
								label="Height Mobile"
								value={heightMobile}
								onChange={(val) => setAttributes({ heightMobile: val })}
							/>
						</PanelRow>
					</PanelBody>
				</Panel>
			</InspectorControls>
			<hr {...useBlockProps()} className="spacer" style={{ '--heightDesktop': `${heightDesktop}px`, '--heightMobile': `${heightMobile}px` }} />
		</>
	);
}
