/**
 * Registers a new block provided a unique name and an object defining its behavior.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-registration/
 */
import { registerBlockType } from '@wordpress/blocks';

/**
 * Lets webpack process CSS, SASS or SCSS files referenced in JavaScript files.
 * All files containing `style` keyword are bundled together. The code used
 * gets applied both to the front of your site and to the editor.
 *
 * @see https://www.npmjs.com/package/@wordpress/scripts#using-css
 */
import './style.scss';

/**
 * Internal dependencies
 */
import Edit from './edit';
import save from './save';
import metadata from './block.json';

/**
 * Every block starts by registering a new block type definition.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-registration/
 */
registerBlockType( metadata.name, {

	icon: (
		<svg xmlns="http://www.w3.org/2000/svg" data-name="Capa 1" viewBox="0 0 81 81"><path d="M55.3 22.6H25.7a1.5 1.5 0 1 0 0 3h29.6a1.5 1.5 0 1 0 0-3m-11.7 8.7-3.1 3-3-3q-1.2-.9-2.2 0-.9 1 0 2.1l4.1 4.2q.5.4 1.1.4.8 0 1-.5l4.2-4q.9-1.2 0-2.2c-.6-.6-1.6-.6-2.1 0m-3.1 11.1q-1.3.2-1.5 1.5v23.2a1.5 1.5 0 1 0 3 0V43.9q-.2-1.3-1.5-1.5" class="prefix__cls-1" /></svg>
	),

	/**
	 * @see ./edit.js
	 */
	edit: Edit,

	/**
	 * @see ./save.js
	 */
	save,
} );
