/**
 * React hook that is used to mark the block wrapper element.
 * It provides all the necessary props like the class name.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/packages/packages-block-editor/#useblockprops
 */
import { InnerBlocks, useBlockProps } from "@wordpress/block-editor";

/**
 * The save function defines the way in which the different attributes should
 * be combined into the final markup, which is then serialized by the block
 * editor into `post_content`.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-edit-save/#save
 *
 * @return {Element} Element to render.
 */
export default function save(props) {
	const { buttonText, buttonTextHover, secID } = props.attributes;

	return (
		<section
			{...useBlockProps.save()}
			className="container text-in-bottom-header"
			data-comp="text-in-bottom-header"
			data-target-id={secID}
		>
			<div className="row">
				<a href={secID} className="col-12-12 center">
					<span>
						{buttonText && <p className="rest">{buttonText}</p>}
						{buttonTextHover && <p className="hover">{buttonTextHover}</p>}
					</span>

					<i className="icon-arrow-down"></i>
				</a>
			</div>
			{!!InnerBlocks.Content ? (
				<header className="row">
					<div className="col-12-8 center">
						<InnerBlocks.Content />
					</div>
				</header>
			) : (
				""
			)}
		</section>
	);
}
