import { RichText, useBlockProps } from "@wordpress/block-editor";

const attributes = {
	titleOne: {
		type: "string",
		default: "",
	},
	subtitleOne: {
		type: "string",
		default: "",
	},
	textOne: {
		type: "string",
		default: "",
	},
	imageOne: {
		type: "string",
		default: "",
	},
	titleTwo: {
		type: "string",
		default: "",
	},
	subtitleTwo: {
		type: "string",
		default: "",
	},
	textTwo: {
		type: "string",
		default: "",
	},
	imageTwo: {
		type: "string",
		default: "",
	},
	titleThree: {
		type: "string",
		default: "",
	},
	subtitleThree: {
		type: "string",
		default: "",
	},
	textThree: {
		type: "string",
		default: "",
	},
	imageThree: {
		type: "string",
		default: "",
	},
	captionOne: {
		type: "string",
		default: "",
	},
	captionTwo: {
		type: "string",
		default: "",
	},
	captionThree: {
		type: "string",
		default: "",
	},
};

const v1 = {
	attributes,
	save: function save(props) {
		const { attributes } = props;

		return (
			<section
				{...useBlockProps.save()}
				className="container three-images-lightbox"
				data-comp="three-images-lightbox"
			>
				<div className="row">
					<article className="col-12-12 images">
						{attributes.imageOne && (
							<div data-comp="openLightbox" className="image first">
								<figure className="img-box">
									<img src={attributes.imageOne} alt="" />
								</figure>
								{attributes.captionOne && (
									<div className="figcaption">
										<RichText.Content
											tagName="span"
											value={attributes.captionOne}
										/>
									</div>
								)}
								{attributes.titleOne && (
									<div className="txt-box">
										{attributes.titleOne && (
											<RichText.Content
												tagName="h3"
												value={attributes.titleOne}
											/>
										)}
										{attributes.subtitleOne && (
											<RichText.Content
												tagName="h2"
												value={attributes.subtitleOne}
											/>
										)}
										{attributes.textOne && (
											<RichText.Content
												tagName="p"
												value={attributes.textOne}
											/>
										)}
									</div>
								)}
							</div>
						)}
						{attributes.imageTwo && (
							<div data-comp="openLightbox" className="image second">
								<figure className="img-box">
									<img src={attributes.imageTwo} alt="" />
								</figure>
								{attributes.captionTwo && (
									<div className="figcaption">
										<RichText.Content
											tagName="span"
											value={attributes.captionTwo}
										/>
									</div>
								)}
								{attributes.titleTwo && (
									<div className="txt-box">
										{attributes.titleTwo && (
											<RichText.Content
												tagName="h3"
												value={attributes.titleTwo}
											/>
										)}
										{attributes.subtitleTwo && (
											<RichText.Content
												tagName="h2"
												value={attributes.subtitleTwo}
											/>
										)}
										{attributes.textTwo && (
											<RichText.Content
												tagName="p"
												value={attributes.textTwo}
											/>
										)}
									</div>
								)}
							</div>
						)}
						{attributes.imageThree && (
							<div data-comp="openLightbox" className="image third">
								<figure className="img-box">
									<img src={attributes.imageThree} alt="" />
								</figure>
								{attributes.captionThree && (
									<div className="figcaption">
										<RichText.Content
											tagName="span"
											value={attributes.captionThree}
										/>
									</div>
								)}
								{attributes.titleThree && (
									<div className="txt-box">
										{attributes.titleThree && (
											<RichText.Content
												tagName="h3"
												value={attributes.titleThree}
											/>
										)}
										{attributes.subtitleThree && (
											<RichText.Content
												tagName="h2"
												value={attributes.subtitleThree}
											/>
										)}
										{attributes.textThree && (
											<RichText.Content
												tagName="p"
												value={attributes.textThree}
											/>
										)}
									</div>
								)}
							</div>
						)}
					</article>
				</div>
			</section>
		);
	},
};
const deprecated = [v1];
export default deprecated;
