import { __ } from '@wordpress/i18n';

import { MediaUpload, useBlockProps, RichText } from '@wordpress/block-editor';
import { Button } from '@wordpress/components';

import './editor.scss';
export default function Edit({ attributes, setAttributes }) {
	const { titleOne, subtitleOne, textOne, imageOne, captionOne, titleTwo, subtitleTwo, textTwo, imageTwo, captionTwo, titleThree, subtitleThree, textThree, imageThree, captionThree, } = attributes;

	return (
	<section  { ...useBlockProps() } className="container three-images-lightbox" data-comp="three-images-lightbox">
		<div className="row">
			<article className="col-12-12 images">
				<div data-comp="openLightbox" className="image first">
					<figure className="img-box">
							<MediaUpload
								onSelect={(media) => setAttributes({ imageOne: media.url })}
								allowedTypes={['image']}
								value={imageOne}
								render={({ open }) => (
									<>
										{imageOne ? (
											<>
												<img src={imageOne} />
												<Button className="bttn--danger" variant="danger" onClick={() => setAttributes({ imageOne: null })}>
													Remove image
												</Button>
											</>
										) : (
											<Button variant="primary" onClick={open}>
												Select image
											</Button>
										)}
									</>
								)}
							/>
					</figure>
					<div className="figcaption">
						<RichText
							placeholder="Image caption"
							tagName="span"
							value={captionOne}
							onChange={(newcaption) => setAttributes({ captionOne: newcaption })}
						/>
					</div>
					<div className="txt-box">
						<RichText
							placeholder="Enter title here..."
							tagName="h3"
							value={titleOne}
							onChange={(newtitle) => setAttributes({ titleOne: newtitle })}
						/>
						<RichText
							placeholder="Enter subtitle here..."
							tagName="h2"
							value={subtitleOne}
							onChange={(newsubtitle) => setAttributes({ subtitleOne: newsubtitle })}
						/>
						<RichText
							placeholder="Enter text here..."
							tagName="p"
							value={textOne}
							onChange={(newtext) => setAttributes({ textOne: newtext })}
						/>
					</div>
				</div>
				<div data-comp="openLightbox" className="image second">
					<figure className="img-box">
							<MediaUpload
								onSelect={(media) => setAttributes({ imageTwo: media.url })}
								allowedTypes={['image']}
								value={imageTwo}
								render={({ open }) => (
									<>
										{imageTwo ? (
											<>
												<img src={imageTwo} />
												<Button className="bttn--danger" variant="danger" onClick={() => setAttributes({ imageTwo: null })}>
													Remove image
												</Button>
											</>
										) : (
											<Button variant="primary" onClick={open}>
												Select image
											</Button>
										)}
									</>
								)}
							/>
					</figure>
					<div className="figcaption">
						<RichText
							placeholder="Image caption"
							tagName="span"
							value={captionTwo}
							onChange={(newcaption) => setAttributes({ captionTwo: newcaption })}
						/>
					</div>
					<div className="txt-box">
						<RichText
							placeholder="Enter title here..."
							tagName="h3"
							value={titleTwo}
							onChange={(newtitle) => setAttributes({ titleTwo: newtitle })}
						/>
						<RichText
							placeholder="Enter subtitle here..."
							tagName="h2"
							value={subtitleTwo}
							onChange={(newsubtitle) => setAttributes({ subtitleTwo: newsubtitle })}
						/>
						<RichText
							placeholder="Enter text here..."
							tagName="p"
							value={textTwo}
							onChange={(newtext) => setAttributes({ textTwo: newtext })}
						/>
					</div>
				</div>
				<div data-comp="openLightbox"  className="image third">
					<figure className="img-box">
						<MediaUpload
							onSelect={(media) => setAttributes({ imageThree: media.url })}
							allowedTypes={['image']}
							value={imageThree}
							render={({ open }) => (
								<>
									{imageThree ? (
										<>
											<img src={imageThree} />
											<Button className="bttn--danger" variant="danger" onClick={() => setAttributes({ imageThree: null })}>
												Remove image
											</Button>
										</>
									) : (
										<Button variant="primary" onClick={open}>
											Select image
										</Button>
									)}
								</>
							)}
						/>
					</figure>
					<div className="figcaption">
						<RichText
							placeholder="Image caption"
							tagName="span"
							value={captionThree}
							onChange={(newcaption) => setAttributes({ captionThree: newcaption })}
						/>
					</div>
					<div className="txt-box">
						<RichText
							placeholder="Enter title here..."
							tagName="h3"
							value={titleThree}
							onChange={(newtitle) => setAttributes({ titleThree: newtitle })}
						/>
						<RichText
							placeholder="Enter subtitle here..."
							tagName="h2"
							value={subtitleThree}
							onChange={(newsubtitle) => setAttributes({ subtitleThree: newsubtitle })}
						/>
						<RichText
							placeholder="Enter text here..."
							tagName="p"
							value={textThree}
							onChange={(newtext) => setAttributes({ textThree: newtext })}
						/>
					</div>
				</div>
			</article>
		</div>
	</section>
	);
}
