/**
 * Registers a new block provided a unique name and an object defining its behavior.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-registration/
 */
import { registerBlockType } from '@wordpress/blocks';

/**
 * Lets webpack process CSS, SASS or SCSS files referenced in JavaScript files.
 * All files containing `style` keyword are bundled together. The code used
 * gets applied both to the front of your site and to the editor.
 *
 * @see https://www.npmjs.com/package/@wordpress/scripts#using-css
 */
import './style.scss';

/**
 * Internal dependencies
 */
import Edit from './edit';
import save from './save';
import metadata from './block.json';

/**
 * Every block starts by registering a new block type definition.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-registration/
 */
registerBlockType( metadata.name, {

	icon: (
		<svg xmlns="http://www.w3.org/2000/svg" data-name="Capa 1" viewBox="0 0 81 81"><path d="M29 40a1.5 1.5 0 1 0 0 3h13.3a1.5 1.5 0 1 0 0-3zm13.2 34.3H29a1.5 1.5 0 1 0 0 3h13.3a1.5 1.5 0 1 0 0-3" class="prefix__cls-1" /><circle cx="35.9" cy="14.4" r="2.5" class="prefix__cls-1" /><path d="M50.6 44.4H30.4c-2.4 0-4.4 2-4.4 4.4v19.5c0 2.4 2 4.4 4.4 4.4h20.2c2.4 0 4.4-2 4.4-4.4V48.8c0-2.5-2-4.4-4.4-4.4m-20.2 3h20.2q1.3.1 1.4 1.4v11.7l-3.6-4.3a1.5 1.5 0 0 0-2.3 0l-5 5.3-1.6-2.2q-.5-.6-1.2-.6t-1.1.5L29 68V48.7q.1-1.2 1.4-1.4Zm20.2 22.3h-19l6.5-7.2 1.8 2.3q.4.5 1 .6.8 0 1.3-.5l5-5.5 4.5 5.4.3.3v3.2q-.1 1.3-1.4 1.4" class="prefix__cls-1" /><circle cx="35.2" cy="53" r="2.9" class="prefix__cls-1" /><path d="M31.4 38.7h16.5c2.5 0 4.4-2 4.4-4.4V8.1c0-2.4-2-4.4-4.4-4.4H31.4c-2.4 0-4.4 2-4.4 4.4v26.2c0 2.4 2 4.4 4.4 4.4m16.5-3H31.4q-1.3-.1-1.4-1.4v-1l7.1-8.5 1.5 2q.4.7 1.1.7T41 27l4.5-5.3 4 5v7.6q-.1 1.3-1.5 1.4m-16.5-29H48q1.3.1 1.4 1.4v13.7l-2.6-3.4a1.5 1.5 0 0 0-2.4 0L40 23.5l-1.5-2.1q-.4-.6-1.1-.7t-1.2.6l-6 7.2V8q0-1.3 1.3-1.4" class="prefix__cls-1" /></svg>
	),

	edit: Edit,
	save,
} );
