
import { __ } from '@wordpress/i18n';

import { MediaUpload, useBlockProps, RichText, InspectorControls } from '@wordpress/block-editor';
import { CheckboxControl, Button, Panel, PanelBody, PanelRow, } from '@wordpress/components';
import { useState } from '@wordpress/element';
import preview from './assets/video-with-cover-text-with-controls.jpg';
export default function Edit({ attributes, setAttributes }) {
	const { text, poster, video, sound } = attributes;
	const [showPoster, setShowPoster] = useState(true);

	return (
		<section {...useBlockProps()} className="container video-with-cover-text-with-controls-and-audio block-editor-block-list__block wp-block" data-comp="video-with-cover-text-with-controls-and-audio" data-state="paused" data-preview="true">

			<figure className="preview">
				<img src={preview} alt="" />
			</figure>

			<InspectorControls key='setting'>
				<Panel className="components-panel--custom">
					<PanelBody>
						<PanelRow>
							<MediaUpload
								allowedTypes={['image']}
								onSelect={(media) => {
									setAttributes({ poster: media.url });
								}}
								multiple={false}
								render={({ open }) => (
									<>
										{poster ? <img src={poster} /> : ''}
										<Button variant="primary" onClick={open}>
											{poster === null
												? "Select poster image"
												: "Change poster image"}
										</Button>
									</>
								)}
							/>
							<CheckboxControl
								label="Show Poster"
								checked={showPoster}
								onChange={() => setShowPoster(!showPoster)}
							/>
							<div className='block'>
								<CheckboxControl
									label="Show Bttn Media"
									checked={sound}
									onChange={(newValue) => setAttributes({ sound: newValue })}
								/>
							</div>
						</PanelRow>
					</PanelBody>
				</Panel>
			</InspectorControls>
			<div className="video-container img-box" data-comp="hideOnPlay" data-show-poster={showPoster} data-sound={sound}>
				<MediaUpload
					onSelect={(media) => setAttributes({ video: media.url })}
					allowedTypes={['video']}
					value={video}
					render={({ open }) => (
						<>
							{video ? (
								<>
									<video playsInline autoPlay loop muted data-type="autoplay" src={video}></video>
									<Button className="bttn--danger" variant="danger" onClick={() => setAttributes({ video: null })}>
										Remove video
									</Button>
								</>
							) : (
								<Button variant="primary" onClick={open}>
									Select video
								</Button>
							)}
						</>
					)}
				/>
				<figure className="poster img-box">
					{poster && (<img src={poster} />)}
				</figure>
			</div>
			<div className="row">
				<div className="col-36-36 text-box">
					<RichText
						tagName="p"
						value={text}
						onChange={(text) => setAttributes({ text })}
						placeholder="Add text"
					/>
				</div>
			</div>
		</section>
	);
}
