import { useBlockProps } from '@wordpress/block-editor';

export default function save(props) {
	const { attributes } = props;

	return (
		<section {...useBlockProps.save()} className="container video-with-cover-text-with-controls-and-audio" data-comp="video-with-cover-text-with-controls-and-audio" data-state="paused">
			<div className="video-container img-box" data-comp="hideOnPlay" data-sound={attributes.sound}>
				{attributes.video && (
					<video playsInline muted loop src={attributes.video}></video>
				)}
				{attributes.poster && (
					<figure className="poster img-box">
						<img src={attributes.poster} />
					</figure>
				)}
			</div>
			<div className="row">
				<div className="col-36-36 text-box">
					{attributes.text && (<p>{attributes.text}</p>)}
				</div>
			</div>
			{attributes.sound && (
			<figcaption data-bttn="play-video" className="mobile">
				<button>play</button>
			</figcaption>
			)}
		</section>
		
	);
}
