import { __ } from "@wordpress/i18n";
import {
	MediaUpload,
	RichText,
	useBlockProps,
	InspectorControls,
	InnerBlocks,
} from "@wordpress/block-editor";
import { Button, Panel, PanelBody, PanelRow } from "@wordpress/components";
import "./editor.scss";

export default function Edit({ attributes, setAttributes }) {
	const { title, text, image, imageMobile, poster, video } = attributes;
	return (
		<section
			{...useBlockProps()}
			className="container gutenberg-component video-with-image-or-graphic-detail-overlap block-editor-block-list__block wp-block"
			data-comp="video-with-image-or-graphic-detail-overlap"
		>
			<InspectorControls key="setting">
				<Panel className="components-panel--custom">
					<PanelBody>
						<PanelRow>
							<MediaUpload
								allowedTypes={['image']}
								onSelect={(media) => setAttributes({ image: media.url })}
								multiple={false}
								render={({ open }) => (
									<>
										{image ? (
											<div>
												<img src={image} alt="Selected Image" />
												<Button className="bttn--danger" variant="danger" onClick={() => setAttributes({ image: null })}>
													Remove Image
												</Button>
											</div>
										) : (
											<div>
												<Button variant="primary" onClick={open}>
													Select Image
												</Button>
											</div>
										)}
									</>
								)}
							/>
							<MediaUpload
								allowedTypes={['image']}
								onSelect={(media) => setAttributes({ imageMobile: media.url })}
								multiple={false}
								render={({ open }) => (
									<>
										{imageMobile ? (
											<div>
												<img src={imageMobile} alt="Selected Image" />
												<Button className="bttn--danger" variant="danger" onClick={() => setAttributes({ imageMobile: null })}>
													Remove Image mobile
												</Button>
											</div>
										) : (
											<div>
												<Button variant="primary" onClick={open}>
													Select Image Mobile
												</Button>
											</div>
										)}
									</>
								)}
							/>
							<MediaUpload
								allowedTypes={['image']}
								onSelect={(media) => setAttributes({ poster: media.url })}
								multiple={false}
								render={({ open }) => (
									<>
										{poster ? (
											<div>
												<img src={poster} alt="Selected Image" />
												<Button className="bttn--danger" variant="danger" onClick={() => setAttributes({ poster: null })}>
													Remove poster
												</Button>
											</div>
										) : (
											<div>
												<Button variant="primary" onClick={open}>
													Select poster
												</Button>
											</div>
										)}
									</>
								)}
							/>
							<MediaUpload
								allowedTypes={["video"]}
								onSelect={(media) => {
									setAttributes({ video: media.url });
								}}
								multiple={false}
								render={({ open }) => (
									<>
										{video ? (
											<div>
												<video
													playsInline
													autoPlay
													loop
													muted
													data-type="autoplay"
													src={video}
												></video>
												<Button className="bttn--danger" variant="danger" onClick={() => setAttributes({ video: null })}>
													Remove video
												</Button>
											</div>
										) : (
											<div>
												<Button variant="primary" onClick={open}>
													Select video
												</Button>
											</div>
										)}
										
									</>
								)}
							/>
						</PanelRow>
					</PanelBody>
				</Panel>
			</InspectorControls>
			<article className="row full-width banner">
				<figure className="outer-video img-box">
					{ video ? (
						<video playsInline autoPlay loop muted data-type="autoplay" src={video}></video>
					) : (
						<img src={poster} />
					)}
				</figure>
				<div className="col-12-12 center text-wrapper">
					<RichText
						placeholder="Enter title here..."
						tagName="h2"
						value={title}
						onChange={(newtitle) => setAttributes({ title: newtitle })}
					/>
				</div>
			</article>
			<div className="row content center">
				<div className="col-12-6 center">
					<RichText
						placeholder="Enter text here..."
						tagName="p"
						value={text}
						onChange={(newtext) => setAttributes({ text: newtext })}
					/>
				</div>
				<figure className="col-12-9 offset-right-1 img-box no-mobile">
					{image && (<img src={image} />)}
				</figure>
				<figure className="col-12-9 offset-right-1 img-box mobile">
					{imageMobile && (<img src={imageMobile} />)}
				</figure>
			</div>
			<div className="row bottom">
				<div className="col-12-12 center">
					<InnerBlocks
						allowedBlocks={['core/separator', 'core/paragraph']}
						template={[
							['core/separator'],
							['core/paragraph', { placeholder: 'Enter subtitle here...', className: 'subtitle' }],
							['core/separator']
						]}
					/>
				</div>
			</div>
		</section>
	);
}
