import { InnerBlocks, useBlockProps, RichText } from "@wordpress/block-editor";
export default function save(props) {
	const { attributes } = props;

	return (
		<>
			<section
				{...useBlockProps.save()}
				className={`container video-with-image-or-graphic-detail-overlap ${
					(attributes.video ? "has-video" : "",
					attributes.image ? "has-image-overlap" : "")
				}`}
				data-comp="video-with-image-or-graphic-detail-overlap"
			>
				<article className="row full-width banner">
					<figure className="outer-video img-box">
						{attributes.video ? (
							<video src={attributes.video} muted autoPlay loop playsInline data-type="autoplay" />
						) : (
							<img src={attributes.poster} alt="" />
						)}
					</figure>
					<div className="col-12-12 center text-wrapper">
						{attributes.title && (
							<RichText.Content tagName="h2" value={attributes.title} />
						)}
					</div>
				</article>
				<div className="row content center">
					<div className="col-12-6 center">
						{attributes.text && (
							<RichText.Content tagName="p" value={attributes.text} />
						)}
					</div>
					{attributes.image && (
						<figure className="col-12-9 img-box">
							<picture className="picture">
								<source media="(min-width: 961px)" srcSet={attributes.image} />
								<source media="(max-width: 960px) and (-webkit-min-device-pixel-ratio: 2)" srcSet={attributes.imageMobile} />
								<img src={attributes.image || attributes.imageMobile} alt="" />
							</picture>
						</figure>
					)}
				</div>
				<div className="row bottom">
					<div className="col-12-12 center">
						<InnerBlocks.Content />
					</div>
				</div>
			</section>
		</>
	);
}
