/**
 * Retrieves the translation of text.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/packages/packages-i18n/
 */
import { __ } from '@wordpress/i18n';

/**
 * React hook that is used to mark the block wrapper element.
 * It provides all the necessary props like the class name.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/packages/packages-block-editor/#useblockprops
 */
import { InnerBlocks, useBlockProps } from '@wordpress/block-editor';

/**
 * Lets webpack process CSS, SASS or SCSS files referenced in JavaScript files.
 * Those files can contain any CSS code that gets applied to the editor.
 *
 * @see https://www.npmjs.com/package/@wordpress/scripts#using-css
 */
import './editor.scss';

/**
 * The edit function describes the structure of your block in the context of the
 * editor. This represents what the editor will render when the block is used.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-edit-save/#edit
 *
 * @return {Element} Element to render.
 */
export default function Edit({ attributes, setAttributes }) {
	const {  } = attributes;

	return (
		<section { ...useBlockProps() } className="container full-text-section">
			<div className="row">
				<div className="col-12-12 center">
					<InnerBlocks
						allowedBlocks={['core/heading', 'core/separator', 'core/heading', 'core/paragraph']}
						template={[
							['core/heading', { level: 3, placeholder: 'Título 1' }],
							['core/separator', { className: 'big' }],
							['core/separator', { className: 'small' }],
							['core/heading', { level: 2, placeholder: 'Título 2' }],
							['core/paragraph', { placeholder: 'Ingrese su párrafo aquí' }],
						]}
					/>
				</div>
			</div>
		</section>
	);
}
