
import { __ } from '@wordpress/i18n';

import { InspectorControls, useBlockProps, RichText, MediaUpload } from '@wordpress/block-editor';
import { Button, CheckboxControl, Panel, PanelBody, PanelRow, TextControl } from '@wordpress/components';

import './editor.scss';

export default function Edit({ attributes, setAttributes }) {
	const { title,
			cta,
			imageOne, 
			imageTwo, 
			imageThree, 
			imageFour, 
			captionOne, 
			captionTwo, 
			captionThree, 
			captionFour 
		} = attributes;

	const onButtonUpdate = (value, type) => {
		const { link, title, target } = attributes.cta;

		const updatedCta = {
			...attributes.cta,
			[type === 'link' ? 'link' : type === 'title' ? 'title' : 'target']: value,
		};

		setAttributes({ cta: updatedCta });
	};

	return (

		<section {...useBlockProps()} className="villas-showcase block-editor-block-list__block wp-block" data-comp="villas-showcase">
			<InspectorControls key='setting'>
				<Panel className="components-panel--custom">
					<PanelBody key="0" title="Settings">
						<PanelRow>
							<TextControl
								label="CTA Link"
								value={Object.keys(cta).length > 0 ? cta.link : ''}
								onChange={(val) => onButtonUpdate(val, 'link')}
							/>
							<TextControl
								label="CTA Text"
								value={Object.keys(cta).length > 0 ? cta.title : ''}
								onChange={(val) => onButtonUpdate(val, 'title')}
							/>
							<CheckboxControl
								label="Open in new tab?"
								help="Link open in new tab"
								checked={Object.keys(cta).length > 0 ? cta.target : 0}
								onChange={(val) => onButtonUpdate(val, 'target')}
							/>
						</PanelRow>
					</PanelBody>
				</Panel>
			</InspectorControls>
			<div className="villas-container">
				<div className="villas-showcase__image">
					<figure className="img-box">
						<MediaUpload
							onSelect={(media) => setAttributes({ imageOne: media.url })}
							allowedTypes={['image']}
							value={imageOne}
							render={({ open }) => (
								imageOne ? (
									<img
										src={imageOne}
										alt=""
										onClick={open}
									/>
								) : (
									<Button variant="primary" onClick={open}>Select Image</Button>
								)
							)}
						/>
					</figure>
					<div className="figcaption">
						<RichText
							tagName="h3"
							value={captionOne}
							onChange={(newValue) => setAttributes({ captionOne: newValue })}
							placeholder="Caption..."
						/>
					</div>
				</div>
				<div className="villas-showcase__image">
					<figure className="img-box">
						<MediaUpload
							onSelect={(media) => setAttributes({ imageTwo: media.url })}
							allowedTypes={['image']}
							value={imageTwo}
							render={({ open }) => (
								imageTwo ? (
									<img
										src={imageTwo}
										alt=""
										onClick={open}
									/>
								) : (
									<Button variant="primary" onClick={open}>Select Image</Button>
								)
							)}
						/>
					</figure>
					<div className="figcaption">
						<RichText
							tagName="h3"
							value={captionTwo}
							onChange={(newValue) => setAttributes({ captionTwo: newValue })}
							placeholder="Caption..."
						/>
					</div>
				</div>
				<div className="villas-showcase__image">
					<figure className="img-box">
						<MediaUpload
							onSelect={(media) => setAttributes({ imageThree: media.url })}
							allowedTypes={['image']}
							value={imageThree}
							render={({ open }) => (
								imageThree ? (
									<img
										src={imageThree}
										alt=""
										onClick={open}
									/>
								) : (
									<Button variant="primary" onClick={open}>Select Image</Button>
								)
							)}
						/>
					</figure>
					<div className="figcaption">
						<RichText
							tagName="h3"
							value={captionThree}
							onChange={(newValue) => setAttributes({ captionThree: newValue })}
							placeholder="Caption..."
						/>
					</div>
				</div>
				<div className="villas-showcase__image no-mobile">
					<figure className="img-box">
						<MediaUpload
							onSelect={(media) => setAttributes({ imageFour: media.url })}
							allowedTypes={['image']}
							value={imageFour}
							render={({ open }) => (
								imageFour ? (
									<img
										src={imageFour}
										alt=""
										onClick={open}
									/>
								) : (
									<Button variant="primary" onClick={open}>Select Image</Button>
								)
							)}
						/>
					</figure>
					<div className="figcaption">
						<RichText
							tagName="h3"
							value={captionFour}
							onChange={(newValue) => setAttributes({ captionFour: newValue })}
							placeholder="Caption..."
						/>
					</div>
				</div>
			</div>
			<div className="villas-showcase__text">
				<RichText
					tagName="h2"
					value={title}
					onChange={(newTitle) => setAttributes({ title: newTitle })}
					placeholder="Title..."
				/>
			</div>
		</section>

	);
}
