import { RichText, useBlockProps } from '@wordpress/block-editor';
export default function save(props) {
	const { attributes } = props;

	return (
		<section {...useBlockProps.save()} className="villas-showcase" data-comp="villas-showcase">
			<div class="villas-container">
				<div class="villas-showcase__image">
					{attributes.imageOne && (
						<figure className="img-box">
							<div className='bg' style={{backgroundImage: `url(${attributes.imageOne})`}}></div>
						</figure>
					)}
					<div class="figcaption">
						<RichText.Content tagName="h3" value={ attributes.captionOne } />
					</div>
				</div>
				<div class="villas-showcase__image">
					{attributes.imageTwo && (
						<figure className="img-box">
							<div className='bg' style={{ backgroundImage: `url(${attributes.imageTwo})` }}></div>
						</figure>
					)}
					<div class="figcaption">
						<RichText.Content tagName="h3" value={ attributes.captionTwo } />
					</div>
				</div>
				<div class="villas-showcase__image">
					{attributes.imageThree && (
						<figure className="img-box">
							<div className='bg' style={{ backgroundImage: `url(${attributes.imageThree})` }}></div>
						</figure>
					)}
					<div class="figcaption">
						<RichText.Content tagName="h3" value={ attributes.captionThree } />
					</div>
				</div>
				<div class="villas-showcase__image no-mobile">
					{attributes.imageFour && (
						<figure className="img-box">
							<div className='bg' style={{ backgroundImage: `url(${attributes.imageFour})` }}></div>
						</figure>
					)}
					<div class="figcaption">
						<RichText.Content tagName="h3" value={ attributes.captionFour } />
					</div>
				</div>
			</div>
			<div class="villas-showcase__text">
				{attributes.title && (<h2>{attributes.title}<i class="icon-iso"></i></h2>)}
				{attributes.cta.link && attributes.cta.title  ? (<a href={attributes.cta.link} target={(attributes.cta.target) ? '_blank' : '_self'} rel="noopener" className="button">{attributes.cta.title}</a>) : null}
			</div>
		</section>

	);
}
