<?php
if(is_page('we-love-indonesia')){
	require_once('includes/geoplugin.class.php');
	$geoPlugin = new geoPlugin();
	$geoPlugin->locate();
	$countryCode = $geoPlugin->countryCode;

	if($countryCode == 'ID'){
		//header('Location: https://nihi.com/offers-packages/');
	}else{
		header('Location: https://nihi.com/offers-packages/');
	}
}
?>

<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo('charset'); ?>" />
<title><?php wp_title('|', true, 'right'); ?></title>
<link rel="profile" href="http://gmpg.org/xfn/11" />
<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />

<link rel="shortcut icon" href="<?php echo get_template_directory_uri(); ?>/img/layout/favicon/favicon_nihi_32.png" type="image/x-icon" sizes="32x32">
<link rel="shortcut icon" href="<?php echo get_template_directory_uri(); ?>/img/layout/favicon/favicon_nihi_128.png" type="image/x-icon" sizes="128x128">
<link rel="shortcut icon" href="<?php echo get_template_directory_uri(); ?>/img/layout/favicon/favicon_nihi_192.png" type="image/x-icon" sizes="192x192">

<!-- Android -->
<link rel="shortcut icon" href="<?php echo get_template_directory_uri(); ?>/img/layout/favicon/favicon_nihi_196.png" type="image/x-icon" sizes="196x196">

<!-- iOS -->
<link rel="apple-touch-icon" href="<?php echo get_template_directory_uri(); ?>/img/layout/favicon/favicon_nihi_152.png" type="image/x-icon" sizes="152x152">
<link rel="apple-touch-icon" href="<?php echo get_template_directory_uri(); ?>/img/layout/favicon/favicon_nihi_167.png" type="image/x-icon" sizes="167x167">
<link rel="apple-touch-icon" href="<?php echo get_template_directory_uri(); ?>/img/layout/favicon/favicon_nihi_180.png" type="image/x-icon" sizes="180x180">

<!-- Windows -->
<link rel="shortcut icon" href="<?php echo get_template_directory_uri(); ?>/img/layout/favicon/smalltile.png" type="image/x-icon" sizes="128x128">
<link rel="shortcut icon" href="<?php echo get_template_directory_uri(); ?>/img/layout/favicon/mediumtile.png" type="image/x-icon" sizes="270x270">
<link rel="shortcut icon" href="<?php echo get_template_directory_uri(); ?>/img/layout/favicon/widetile.png" type="image/x-icon" sizes="558x270">
<link rel="shortcut icon" href="<?php echo get_template_directory_uri(); ?>/img/layout/favicon/largetile.png" type="image/x-icon" sizes="558x558">

<!-- mobile Specific Metas -->
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />
<meta names="apple-mobile-web-app-status-bar-style" content="black-translucent">
<meta name="apple-mobile-web-app-capable" content="yes" />
<meta name="format-detection" content="telephone=no">

<?php
if (get_field('header_scripts', 'options')) { ?>
	<?= get_field('header_scripts', 'options'); ?>
<?php } ?>

<script type="text/javascript">
	const site_url = '<?php echo home_url(); ?>';
	const site_template = '<?php echo get_template_directory_uri(); ?>';
	const page_title = '<?php wp_title('|', true, 'right'); ?>';
	const referer_url = '<?php echo isset($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : ''; ?>';
	const current_url = '<?php echo home_url($wp->request); ?>';
</script>

<?php
wp_head();
?>

<link rel="stylesheet" href="<?php bloginfo('stylesheet_url'); ?>" />
<link rel="stylesheet" type="text/css" href="<?php echo get_template_directory_uri(); ?>/custom.css">
<!-- --><link rel="stylesheet" type="text/css" href="<?php echo site_url(); ?>/wp-content/themes/fonts/fonts.css">
</head>
<?php
$bodyClass = 'generic';
if ($post) {
	$bodyClass = $post->post_name;
}
?>

<body <?php body_class('current-page-' . $bodyClass); ?> data-state="closed-menu" data-rates="closed">

	<nav class="container site-nav" data-comp="siteNav">
		<div class="row bottom">
			<div class="col-logo">
				<a href="<?php echo home_url(); ?>">
					<?= wp_get_attachment_image(get_field('main_logo', 'options'), 'full', false, array('class' => 'main', 'alt' => 'NIHI Rote')); ?>
					<?= wp_get_attachment_image(get_field('secondary_logo', 'options'), 'full', false, array('class' => 'secondary', 'alt' => 'NIHI Rote')); ?>
				</a>
			</div>

			<div class="col-content no-mobile">
				<?php
				$menu = wp_get_nav_menu_items('Main Menu');

				if ($menu) {
					wp_nav_menu(array('menu' => 'Main Menu', 'menu_class' => 'main-menu', 'container_class' => 'main-menu-container'));
				}
				?>
			</div>
			<div class="col-actions">
				<?php if (get_field('rates', 'options')) { ?>
					<!--rix--><div class="booknow">
						<!--<button class="bttn-booknow" type="button">Book now</button>--><a href='https://be.synxis.com/?chain=24447&hotel=6953&adult=2&SRC=30' class="bttn-booknow" >Book Now</a><!--rix-->
						
					</div>
					<button class="bttn-toggle-menu" data-bttn="toggle-menu">
						<em>Menu</em>
						<svg xmlns="http://www.w3.org/2000/svg" width="26" height="12" viewBox="0 0 26 12">
							<g id="MORE_MENU" data-name="MORE MENU" transform="translate(1 1)">
								<path id="Trazado_11142" data-name="Trazado 11142" d="M0,0H24" fill="none" stroke="#86CDAF" stroke-linecap="round" stroke-width="2" />
								<path id="Trazado_11143" data-name="Trazado 11143" d="M0,0H24" transform="translate(0 5)" fill="none" stroke="#86CDAF" stroke-linecap="round" stroke-width="2" />
								<path id="Trazado_11144" data-name="Trazado 11144" d="M0,0H24" transform="translate(0 10)" fill="none" stroke="#86CDAF" stroke-linecap="round" stroke-width="2" />
							</g>
						</svg>
					</button>
				<?php } ?>
			</div>
		</div>
	</nav>

	<section class="container fixed-menu" data-lenis-prevent>
		<div class="row stretch">
			<div class="col-top">
				<div class="logo">
					<?= wp_get_attachment_image(get_field('secondary_logo', 'options'), 'full', false, array('class' => 'secondary')); ?>
				</div>
				<div class="languages">
					<?php
					if (have_rows('languages', 'options')) {
						while (have_rows('languages', 'options')) {
							the_row();

							$link = get_sub_field('language', 'options');
							if ($link) {
					?>
								<a class="textlink" href="<?php echo esc_url($link['url']); ?>" target="<?php echo esc_attr($link['target']); ?>"><?php echo esc_html($link['title']); ?></a>
					<?php
							}
						}
					}
					?>
				</div>
				<div class="main-menu-container">
					<?php
					$menu = wp_get_nav_menu_items('Main Menu');

					if ($menu) {
						wp_nav_menu(array('menu' => 'Main Menu', 'menu_class' => 'main-menu', 'container_class' => 'main-menu-wrapper'));
					}
					?>
					<ul class="social-media">
						<?php
						if (have_rows('social_media', 'options')) {
							while (have_rows('social_media', 'options')) {
								$i = 0;
								the_row();
								if ($i == 0) { ?>
									<li class="social-media__instagram"><a href="<?= get_sub_field('url'); ?>" target="_blank"><img src="<?= wp_get_attachment_image_url(get_sub_field('logo'), 'full'); ?>"></a></li>
								<?php }
								if ($i == 1) { ?>
									<li class="social-media__facebook"><a href="<?= get_sub_field('url'); ?>" target="_blank"><img src="<?= wp_get_attachment_image_url(get_sub_field('logo'), 'full'); ?>"></a></li>
								<?php }
								if ($i == 2) { ?>
									<li class="social-media__youtube"><a href="<?= get_sub_field('url'); ?>" target="_blank"><img src="<?= wp_get_attachment_image_url(get_sub_field('logo'), 'full'); ?>"></a></li>
								<?php }
								if ($i == 3) { ?>
									<li class="social-media__whatsapp"><a href="<?= get_sub_field('url'); ?>" target="_blank"><img src="<?= wp_get_attachment_image_url(get_sub_field('logo'), 'full'); ?>"></a></li>
						<?php }
							}
						}
						?>
					</ul>
				</div>
				<div class="properties no-mobile">
					<h3><?= get_field('op_text', 'options'); ?></h3>
					<ul>
						<?php
						if (have_rows('properties', 'options')) {
							while (have_rows('properties', 'options')) {
								the_row(); ?>
								<li>
									<?php if (get_sub_field('url')) { ?>
										<a href="<?php the_sub_field('url', 'options'); ?>" target="_blank"><?= wp_get_attachment_image(get_sub_field('logo'), 'full'); ?></a>
									<?php } else { ?>
										<?= wp_get_attachment_image(get_sub_field('logo'), 'full'); ?>
									<?php } ?>
								</li>
						<?php
							}
						}
						?>
					</ul>
				</div>
			</div>
			<div class="col-bottom">
				<?php
				if (has_nav_menu('secondary-menu')) {
					wp_nav_menu(array('menu' => 'Secondary Menu', 'menu_class' => 'secondary-menu', 'container_class' => 'secondary-menu-container'));
				}
				?>
			</div>
		</div>
	</section>

	<div id="smooth-wrapper">
		<div id="smooth-content">
