<?php
add_filter('wpcf7_autop_or_not', '__return_false');
add_action( 'init', 'register_parks_menus' );

function register_parks_menus() {
    register_nav_menus(
        array(
            'main-menu' => __( 'Main Menu' ),
            'secondary-menu' => __( 'Secondary Menu' ),
            'our-commitment' => __( 'Our commitment' ),
            'about-nihi' => __( 'About nihi' ),
            'plan-your-visit' => __( 'Plan your visit' ),
            'residential' => __( 'Residential' ),
            'special-occasions' => __( 'Special occasions' )
        )
    );
}

//ACF
if (function_exists('acf_add_options_page')) {

    acf_add_options_page(array(
        'page_title'     => 'Information',
        'menu_title'    => 'Information',
        'menu_slug'     => 'information',
        'capability'    => 'edit_posts',

    ));
}

// Allow SVG
add_filter( 'wp_check_filetype_and_ext', function($data, $file, $filename, $mimes) {

    global $wp_version;
    if ( $wp_version !== '4.7.1' ) {
       return $data;
    }
  
    $filetype = wp_check_filetype( $filename, $mimes );
  
    return [
        'ext'             => $filetype['ext'],
        'type'            => $filetype['type'],
        'proper_filename' => $data['proper_filename']
    ];
  
  }, 10, 4 );
  
  function cc_mime_types( $mimes ){
    $mimes['svg'] = 'image/svg+xml';
    return $mimes;
  }
  add_filter( 'upload_mimes', 'cc_mime_types' );
  
  function fix_svg() {
    echo '<style type="text/css">
          .attachment-266x266, .thumbnail img {
               width: 100% !important;
               height: auto !important;
          }
          </style>';
  }
  add_action( 'admin_head', 'fix_svg' );

//rix
function wpdocs_remove_menus() {
	if ( get_current_user_id() != "1" && get_current_user_id() != "20" ){
	//remove_menu_page('update-core.php');
    remove_menu_page('index.php'); //Dashboard
    //remove_menu_page('edit.php'); //Posts
    //remove_menu_page('upload.php'); //Media
    //remove_menu_page('edit.php?post_type=page'); //Pages
    remove_menu_page('edit-comments.php'); //Comments
    //remove_menu_page('themes.php'); //Appearance
    remove_menu_page('plugins.php'); //Plugins
    //remove_menu_page('users.php'); //Users
    remove_menu_page('tools.php'); //Tools
    remove_menu_page('options-general.php'); //Settings
    remove_menu_page('options-general.php?page=tinymce-advanced'); //Settings
	remove_menu_page('options-general.php?page=google-sitemap-generator/sitemap.php'); //Settings
	remove_menu_page('options-general.php?page=cpto-options'); //Settings
    //remove_menu_page('edit.php?post_type=project'); //Projects
    remove_menu_page('insert-html-snippet-manage'); 
	}

}
add_action('admin_menu', 'wpdocs_remove_menus');

function wpdocs_remove_menusThree() {
    if (get_current_user_id() != "1" && get_current_user_id() != "20" ) {
	remove_submenu_page('edit.php?post_type=villas','edit.php?post_type=villas&page=to-interface-villas');
	remove_submenu_page('edit.php?post_type=excursion','edit.php?post_type=excursion&page=to-interface-excursion');
	remove_submenu_page('edit.php?post_type=wellness','edit.php?post_type=wellness&page=to-interface-wellness');
    }
}
add_action('admin_menu', 'wpdocs_remove_menusThree');

//rix
//add_filter('acf/settings/show_admin', '__return_false');
add_filter('acf/settings/show_admin', 'my_acf_show_admin');
function my_acf_show_admin( $show ) { 
if ( get_current_user_id() == "1" && get_current_user_id() != "20"  ){
return true;
   }
else {
return false;
   }
}
