<?php

// Register/Enqueue css and js
add_action( 'wp_print_scripts', 'enqueue_theme_scripts' );
add_action( 'wp_print_styles', 'enqueue_theme_styles' );

function enqueue_admin_block_scripts( $hook ) {
    wp_register_script('uuid', "https://unpkg.com/uuidjs@^5", array(), '1.0', true);
    wp_enqueue_script( 'uuid');
}
add_action( 'admin_enqueue_scripts', 'enqueue_admin_block_scripts' );
/**
 * Theme Scripts/Styles
 */

function enqueue_theme_styles() {
    // Register styles
    wp_register_style( 'reset', get_template_directory_uri() . '/css/libraries/reset.css' );
    wp_register_style( 'grid', get_template_directory_uri() . '/css/libraries/grid.css' );
    wp_register_style( 'splide', get_template_directory_uri() . '/css/libraries/splide.min.css' ); 
    wp_register_style( 'main', get_template_directory_uri() . '/css/main.css' );

    // Components
    wp_register_style( 'site-nav', get_template_directory_uri() . '/css/components/site-nav.css' );
    wp_register_style( 'site-footer', get_template_directory_uri() . '/css/components/site-footer.css' );
    
    // Tercera instancia
    wp_register_style( 'rates-comparative-villas', get_template_directory_uri() . '/css/components/rates-comparative-villas.css' );
    
    // Pages
    wp_register_style( 'error', get_template_directory_uri() . '/css/pages/404.css' );
    wp_register_style( 'generic', get_template_directory_uri() . '/css/pages/generic.css' );
    wp_register_style( 'have-fun-filter', get_template_directory_uri() . '/css/components/have-fun-filter.css' );
    wp_register_style( 'villas-have-fun-filtered', get_template_directory_uri() . '/css/components/villas-have-fun-filtered.css' );
    wp_register_style( 'table-rates', get_template_directory_uri() . '/css/components/table-rates.css' );

    // Flatpicker
    wp_register_style('flatpicker', get_template_directory_uri() . '/css/libraries/flatpicker.min.css');


    // enqueue styles
    wp_enqueue_style( 'flatpicker' );
    wp_enqueue_style( 'splide' );
    wp_enqueue_style( 'main' );
    wp_enqueue_style( 'site-nav' );
    wp_enqueue_style( 'site-footer' );

     // Tercera instancia
    wp_enqueue_style( 'rates-comparative-villas' );


    // Don't delete
    wp_enqueue_style( 'villas-have-fun-filtered' );
    wp_enqueue_style( 'have-fun-filter' );
    wp_enqueue_style( 'table-rates' );

    // Generic
    if (is_page_template('templates/generic.php')):
        wp_enqueue_style( 'generic' );
    endif;

    // 404
    if (is_404()):
        wp_enqueue_style( 'error' );
    endif;

}

function enqueue_theme_scripts() {
    // Register scripts
    // if(!is_admin()) wp_register_script('jquery3', get_template_directory_uri() . '/js/libraries/jquery-3.2.1.min.js','', '3.2.1', true); // Don't load script if is in admincp
    wp_register_script('browserDetection', get_template_directory_uri() . '/js/libraries/browserDetection.js', array(), '1.0', true);
    
    wp_register_script('objectFitPolyfill', get_template_directory_uri() . '/js/libraries/objectFitPolyfill.min.js', array(), '1.0', true);
    wp_register_script('splide', get_template_directory_uri() . '/js/libraries/splide.min.js', '', '1.0', true);
    wp_register_script('splide-auto-scroll', get_template_directory_uri() . '/js/libraries/splide-extension-auto-scroll.min.js', '', '1.0', true);
    wp_register_script('functions', get_template_directory_uri() . '/js/page-functions.js', array(), '1.0', true);
    wp_register_script('components', get_template_directory_uri() . '/js/page-components.js', array(), '1.0', true);
    wp_register_script('views', get_template_directory_uri() . '/js/page-views.js', array(), '1.0', true);
    wp_register_script('html5shiv', get_template_directory_uri() . '/js/libraries/html5shiv.js', array(), '1.0', true);
    wp_register_script('simpleParalax', get_template_directory_uri() . '/js/libraries/simpleParalax.js', array(), '1.0', true);
    wp_register_script('lenis', get_template_directory_uri() . '/js/libraries/lenis.min.js', array(), '1.0', true);
    wp_register_script('gsap', get_template_directory_uri() . '/js/libraries/gsap.min.js', array(), '1.0', true);
    wp_register_script('gsap-scrollTrigger', get_template_directory_uri() . '/js/libraries/gsap-scrolltrigger.min.js', array(), '1.0', true);
    // MAPS
    //wp_register_script('gmaps', 'https://maps.googleapis.com/maps/api/js?key=AIzaSyC6fSWbIG6UNfND6HTWePulPdXqd9yFQng&callback=gmapsInit&libraries=marker&v=beta', array(), null, true);
    //wp_register_script('maped', get_template_directory_uri() . '/js/libraries/maped.js', array(), '1.0', true);
    //wp_register_script('infobubble-compiled', get_template_directory_uri() . '/js/libraries/infobubble-compiled.js', array(), '1.0', true);
    
    // Flatpicker
    wp_register_script('flatpicker', get_template_directory_uri() . '/js/libraries/flatpicker.min.js', array(), '1.0', true);

    // Pages
    // wp_register_script('frontpage', get_template_directory_uri() . '/js/pages/front-page.js', array(), '1.0', true);

    // Components
    wp_register_script('footer', get_template_directory_uri() . '/js/components/footer.js', array(), '1.0', true);
    wp_register_script('slider-header-autoplay', get_template_directory_uri() . '/js/components/slider-header-autoplay.js', array(), '1.0', true);
    wp_register_script('header-mosaico-parallax', get_template_directory_uri() . '/js/components/header-mosaico-parallax.js', array(), '1.0', true);
    wp_register_script('video-with-cover-text-with-controls-and-audio', get_template_directory_uri() . '/js/components/video-with-cover-text-with-controls-and-audio.js', array(), '1.0', true);
    wp_register_script('video-with-image-or-graphic-detail-overlap', get_template_directory_uri() . '/js/components/video-with-image-or-graphic-detail-overlap.js', array(), '1.0', true);
    wp_register_script('banner-with-graphic-overlap', get_template_directory_uri() . '/js/components/banner-with-graphic-overlap.js', array(), '1.0', true);
    wp_register_script('side-by-side-image-video', get_template_directory_uri() . '/js/components/side-by-side-image-video.js', array(), '1.0', true);
    wp_register_script('village-showcase', get_template_directory_uri() . '/js/components/village-showcase.js', array(), '1.0', true);
    wp_register_script('imgs-overlapping-text', get_template_directory_uri() . '/js/components/imgs-overlapping-text.js', array(), '1.0', true);
    wp_register_script('three-images-lightbox', get_template_directory_uri() . '/js/components/three-images-lightbox.js', array(), '1.0', true);
    wp_register_script('have-fun-thumbnail', get_template_directory_uri() . '/js/components/have-fun-thumbnail.js', array(), '1.0', true);
    wp_register_script('villas-have-fun', get_template_directory_uri() . '/js/components/villas-have-fun.js', array(), '1.0', true);
    wp_register_script('image-gallery', get_template_directory_uri() . '/js/components/image-gallery.js', array(), '1.0', true);
    wp_register_script('have-fun-filter', get_template_directory_uri() . '/js/components/have-fun-filter.js', array(), '1.0', true);
    wp_register_script('rates-comparative-villas', get_template_directory_uri() . '/js/components/rates-comparative-villas.js', array(), '1.0', true);
    wp_register_script('text-in-bottom-header', get_template_directory_uri() . '/js/components/text-in-bottom-header.js', array(), '1.0', true);
    wp_register_script('map-and-title', get_template_directory_uri() . '/js/components/map-and-title.js', array(), '1.0', true);
    wp_register_script('paragraph-for-prices-or-announcements', get_template_directory_uri() . '/js/components/paragraph-for-prices-or-announcements.js', array(), '1.0', true);
	if(!is_front_page()){
    wp_register_script('accordion-simple', get_template_directory_uri() . '/js/components/accordion-simple.js', array(), '1.0', true);
    wp_register_script('accordion-complex', get_template_directory_uri() . '/js/components/accordion-complex.js', array(), '1.0', true);
    wp_register_script('accordion-tabs', get_template_directory_uri() . '/js/components/accordion-tabs.js', array(), '1.0', true);
    wp_register_script('accordion-two-columns', get_template_directory_uri() . '/js/components/accordion-two-columns.js', array(), '1.0', true);
    wp_register_script('floorplans-gallery', get_template_directory_uri() . '/js/components/floorplans-gallery.js', array(), '1.0', true);
	}
    wp_register_script('form-contact-details', get_template_directory_uri() . '/js/components/form-contact-details.js', array(), '1.0', true);
    wp_register_script('gallery-of-three-videos', get_template_directory_uri() . '/js/components/gallery-of-three-videos.js', array(), '1.0', true);
    wp_register_script('icon-horizontal-slider', get_template_directory_uri() . '/js/components/icon-horizontal-slider.js', array(), '1.0', true);
    wp_register_script('animated-button', get_template_directory_uri() . '/js/components/animated-button.js', array(), '1.0', true);
	if(!is_front_page()){
    wp_register_script('have-fun-filter-check', get_template_directory_uri() . '/js/components/have-fun-filter-check.js', array(), '1.0', true);
    wp_register_script('have-fun-filter-back', get_template_directory_uri() . '/js/components/have-fun-filter-back.js', array(), '1.0', true);
	}
    wp_register_script('have-fun-activities-crosseling', get_template_directory_uri() . '/js/components/have-fun-activities-crosseling.js', array(), '1.0', true);
    if (is_admin()) {
        return;
    }

    // Add conditional to scripts
    wp_script_add_data( 'html5shiv', 'conditional', 'lt IE 9' );

    // enqueue scripts
    //if(!is_admin('jquery3')) wp_enqueue_script(); // FTR: is_admin() check if the the current page is an administration page. Despite its name this is not a user role check.
    wp_enqueue_script('browserDetection');
    wp_enqueue_script( 'html5shiv');
    wp_enqueue_script( 'splide');
    wp_enqueue_script( 'splide-auto-scroll');
    wp_enqueue_script( 'simpleParalax');
    wp_enqueue_script( 'lenis');
    wp_enqueue_script( 'gsap');
    wp_enqueue_script( 'gsap-scrollTrigger');
    wp_enqueue_script( 'flatpicker');

    wp_enqueue_script( 'functions');
    
    //wp_enqueue_script( 'gmaps');
    //wp_enqueue_script( 'maped');
    //wp_enqueue_script( 'infobubble-compiled');
    
    wp_enqueue_script( 'components');
    wp_enqueue_script( 'views');
    
    wp_enqueue_script( 'footer');
    wp_enqueue_script( 'slider-header-autoplay');
    wp_enqueue_script( 'header-mosaico-parallax');
    wp_enqueue_script( 'video-with-cover-text-with-controls-and-audio');
    wp_enqueue_script( 'video-with-image-or-graphic-detail-overlap');
    wp_enqueue_script( 'banner-with-graphic-overlap');
    wp_enqueue_script( 'side-by-side-image-video');
    wp_enqueue_script( 'village-showcase');
    wp_enqueue_script( 'imgs-overlapping-text');
    wp_enqueue_script( 'three-images-lightbox');
    wp_enqueue_script( 'have-fun-thumbnail');
    wp_enqueue_script( 'villas-have-fun');
    wp_enqueue_script( 'image-gallery');
    wp_enqueue_script( 'have-fun-filter');
    wp_enqueue_script( 'rates-comparative-villas');
    wp_enqueue_script( 'text-in-bottom-header');
    wp_enqueue_script( 'map-and-title');
    wp_enqueue_script( 'paragraph-for-prices-or-announcements');
	if(!is_front_page()){
    wp_enqueue_script( 'accordion-simple');
    wp_enqueue_script( 'accordion-complex');
    wp_enqueue_script( 'accordion-tabs');
    wp_enqueue_script( 'accordion-two-columns');
    wp_enqueue_script( 'floorplans-gallery');
	}
    wp_enqueue_script( 'gallery-of-three-videos');
    wp_enqueue_script( 'icon-horizontal-slider');
    wp_enqueue_script( 'animated-button');
	if(!is_front_page()){
    wp_enqueue_script( 'have-fun-filter-check');
    wp_enqueue_script( 'have-fun-filter-back');
	}
    wp_enqueue_script( 'have-fun-activities-crosseling');

    // if ( is_front_page() ):
    //     wp_enqueue_script( 'frontpage' );
    //     wp_enqueue_script( 'live-block-overlay' );
    // endif;
    // if ( is_page_template('templates/about.php') ):
    //     wp_enqueue_script( 'about' );
    // endif;
}
