<?php
// Hook into the 'init' action
add_action( 'init', 'custom_taxonomy', 0 );

// Register Custom Taxonomy
function custom_taxonomy() {

    register_taxonomy('villas_type', 'villas', array(
        'label' => 'Category',
        'description' => 'Category',
        'public' => true,
        'show_ui' => true,
        'show_in_menu' => true,
        'show_in_rest' => true,
        '_builtin' => false,
        'hierarchical' => true,
        'query_var' => true,
        'rewrite' => array('slug' => 'villas'),
        'labels' => array (
            'name' => 'Category',
            'singular_name' => 'Category',
            'menu_name' => 'Category',
            'add_new' => 'Add Category',
            'add_new_item' => 'Add Category',
            'edit' => 'Edit',
            'edit_item' => 'Edit Category',
            'new_item' => 'New Category',
            'view' => 'View Category',
            'view_item' => 'View Category',
            'search_items' => 'Search Category',
            'not_found' => 'No Category Found',
            'not_found_in_trash' => 'No Category Found in Trash',
        ),
    ));

    register_taxonomy('excursions', array('excursion', 'wellness'), array(
        'label' => 'Category',
        'description' => 'Category',
        'public' => true,
        'show_ui' => true,
        'show_in_menu' => true,
        'show_in_rest' => true,
        '_builtin' => false,
        'hierarchical' => true,
        'query_var' => true,
        'rewrite' => array('slug' => 'excursions'),
        'labels' => array (
            'name' => 'Category',
            'singular_name' => 'Category',
            'menu_name' => 'Category',
            'add_new' => 'Add Category',
            'add_new_item' => 'Add Category',
            'edit' => 'Edit',
            'edit_item' => 'Edit Category',
            'new_item' => 'New Category',
            'view' => 'View Category',
            'view_item' => 'View Category',
            'search_items' => 'Search Category',
            'not_found' => 'No Category Found',
            'not_found_in_trash' => 'No Category Found in Trash',
        ),
    ));

    register_taxonomy('wellness_category', array('excursion', 'wellness'), array(
        'label' => 'Category',
        'description' => 'Category',
        'public' => true,
        'show_ui' => true,
        'show_in_menu' => true,
        'show_in_rest' => true,
        '_builtin' => false,
        'hierarchical' => true,
        'query_var' => true,
        'rewrite' => array('slug' => 'wild-wellness'),
        'labels' => array(
            'name' => 'Category',
            'singular_name' => 'Category',
            'menu_name' => 'Category',
            'add_new' => 'Add Category',
            'add_new_item' => 'Add Category',
            'edit' => 'Edit',
            'edit_item' => 'Edit Category',
            'new_item' => 'New Category',
            'view' => 'View Category',
            'view_item' => 'View Category',
            'search_items' => 'Search Category',
            'not_found' => 'No Category Found',
            'not_found_in_trash' => 'No Category Found in Trash',
        ),
    ));
}
