class AccordionComplex {
    constructor(sel) {
        // view
        this.components = document.querySelectorAll(sel);
        this.sel = sel;

        if (this.components.length > 0) {
            this.init();
        }
    }

    init() {
        this.components.forEach((component) => {
            const accordions = component.querySelectorAll('.accordion');

            this.setAccordionsOffsetOnMobile(accordions, component);


            accordions.forEach((accordion) => {
                accordion.addEventListener('click', (e) => {
                    const isActive = this.hasState('active', accordion);

                    if (isActive) {
                        this.scrollToAccordionOnMobile(accordion);
                    }

                    this.resetNodesState('active', accordions);

                    isActive ? null : this.setState('active', accordion);
                });
                accordion.querySelectorAll('a').forEach((a) =>
                    a.addEventListener('click', (e) => {
                        e.stopPropagation();
                    })
                );
            });
            if (component.classList.contains('first-open') && accordions[0]) {
                this.setState('active', accordions[0], false);
            }
        });
    }

    scrollToAccordionOnMobile = (node) => {
        if (WW > 961) return;

        const componentOffset =
            window.scrollY + node.closest(this.sel).getBoundingClientRect().top;
        if (lenis) {
            lenis.scrollTo(Number(componentOffset) + Number(node.dataset.offset));
            return
        }
        window.scroll({
            top: Number(componentOffset) + Number(node.dataset.offset),
            behavior: "smooth",
        });
    };
    setAccordionsOffsetOnMobile = (accordions, component) => {
        if (WW > 961) return;
        const componentOffset =
            window.scrollY + component.getBoundingClientRect().top;

        accordions.forEach((accordion) => {
            const accordionOffset =
                window.scrollY + accordion.getBoundingClientRect().top - 100;
            accordion.dataset.offset = accordionOffset - componentOffset;
        });
    };
    resetNodesState = (state, nodes) => {
        nodes.forEach((node) => {
            const content = node.querySelector('.content-wrapper');
            content.style.maxHeight = 0;
            node.classList.toggle(state, false);
        });
    };
    setState = (state, node, scrollToOnMobile = true) => {
        const content = node.querySelector('.content-wrapper');
        content.style.maxHeight = 'none';
        const height = content.getBoundingClientRect().height;
        content.style.maxHeight = 0;

        if (scrollToOnMobile) {
            this.scrollToAccordionOnMobile(node);
        }

        requestAnimationFrame(() => {
            content.style.maxHeight = height + 66 + 'px'; // height plus margin
            node.classList.toggle(state, true);
        });
    };
    hasState = (state, node) => node.classList.contains(state);
}
