class AnimatedButtonVideos {
    constructor(elementsList) {

        this.created = false;
        this.selectorButton = "float-button-video";
        this.button = "";
        this.ease = .08;
        this.pos = { x: 0, y: 0 };
        this.mouse = { x: 0, y: 0 };
        this.elementsList = elementsList;

        this.init();

    }
    init() {

        if (!this.created) this.createButton();

        gsap.set(this.button, { autoAlpha: 1, scale: 0, x: 0, y: 0 });

        window.addEventListener('mousemove', (e) => {
            this.mouse.x = e.clientX;
            this.mouse.y = e.clientY;
            gsap.ticker.add(this.updatePosition.bind(this));
        });
        if (this.elementsList) {
            this.elementsList.forEach(element => {
                let targets = document.querySelectorAll(element.target);
                if (targets.length) {
                    targets.forEach(item => {
                        this.events(item, element);
                    });
                }
            });
        }
    }
    createButton() {
        let button = `<button class="${this.selectorButton}"><span>view more</span></button>`;
        document.body.insertAdjacentHTML('afterend', button);
        this.created = true;
        this.button = document.querySelector("." + this.selectorButton);
    }
    updatePosition() {
        this.pos.x += (this.mouse.x - this.pos.x - 35) * this.ease;
        this.pos.y += (this.mouse.y - this.pos.y - 35) * this.ease;
        gsap.set(this.button, { x: this.pos.x, y: this.pos.y })
    }
    updateText(text) {
        if (text && text !== "") {
            this.button.querySelector("span").textContent = text;
        }
    }
    updateClass(customClass) {
        if (customClass && customClass !== "") this.button.dataset.class = customClass;
    }
    events(item, element) {
        item.addEventListener('mouseenter', () => {
            this.updateText(element.text);
            this.updateClass(element.class);
            gsap.to(this.button, { scale: 1, duration: 0.2, overwrite: true, delay: 0.2 });
        });
        item.addEventListener('mouseleave', () => {
            gsap.to(this.button, { scale: 0, duration: 0.01, overwrite: true });
        });
        if (element.callback) {
            item.addEventListener('click', e => {
                e.preventDefault();
                element.callback(e, this.button, element);
            });
        }
    }
}
