class FloatButton {
    constructor(sel) {
        // view
        this.component = document.querySelector(sel);
        this.selector = "[data-bttn='float-button']";


        if (this.component) {
            this.init();
        }
    }

    init() {

        this.createButton();

        this.cursorPosition();

    }
    createButton() {
        let button = "<button class='fixed-button' data-bttn='float-button'><span>CALL TO ACTION ITEM 1</span></button>";
        document.body.insertAdjacentHTML('afterend', button);
    }
    cursorPosition () {

        gsap.set(this.selector, { xPercent: 10, yPercent: 10 })

        let cursor = document.querySelector(this.selector);

        let mouseX;
        let mouseY;

        window.addEventListener('mousemove', e => {
            mouseX = e.clientX;
            mouseY = e.clientY;

            gsap.to(cursor, 0.5, { x: mouseX, y: mouseY });
        })
    }
    showCursor () {
        this.articles.forEach(article => {
            article.addEventListener('mouseenter', () => {
                cursor.classList.add("show");
            })
            article.addEventListener('mouseleave', () => {
                cursor.classList.remove("show");
            })
            article.addEventListener('click', e => {
                let URL = e.target.parentNode.dataset.url;
                window.open(URL, "_self");
            })
        });
    }
}