class FloorplansGallery {

    constructor(sel) {
        // view
        this.component = document.querySelector(sel);
        this.splide = this.component.querySelector(".splide");

        this.header = this.component.querySelector('header');
        this.article = this.component.querySelector('article');
        this.rowTarget = this.component.querySelector('.row.full-width');

        this.resizeTimer = "";
        this.rightMargin = "";
        this.headerStyle = "";
        this.articleStyle = "";

        if (this.component) {
            this.init();
        }
    }

    init() {
        console.log("FloorplansGallery");

        this.splide = new Splide( this.splide, {
            type: 'loop',
            arrows: true,
            pagination: false,
            perPage: 2,
            gap: '2rem',
            breakpoints: {
                1440: {
                    gap: '2rem',
                    perPage: 2,
                },
                960: {
                    gap: '1rem',
                    perPage: 1,
                },
            },
        }).mount();


        this.resize();
        window.addEventListener('resize', this.resize, {
            passive: true
        });

    }
    resize = function (e) {
        this.rightMargin = 0;
        this.size = 0;
        this.headerStyle = this.header.currentStyle || window.getComputedStyle(this.header);
        this.articleStyle = this.article.currentStyle || window.getComputedStyle(this.article);

        clearTimeout(this.resizeTimer);
        this.resizeTimer = setTimeout( () => {
            if (WW > 961) {
                this.rightMargin = parseInt(this.headerStyle.marginLeft) + parseInt(this.articleStyle.marginLeft);

                console.log(this.header, this.article);

                this.size = WW - this.rightMargin;
                this.rowTarget.style.width = this.size + 'px';
                this.rowTarget.style.marginLeft = this.rightMargin + 'px';
            } else {
                this.rowTarget.removeAttribute('style');
            }
        }, 250);
    }


}