class FloorplansGallery {

    constructor(sel) {
        // view
        this.components = document.querySelectorAll(sel);

        if (this.components.length > 0) {
            this.components.forEach(component => {
                this.init(component);
            });
        }
    }

    init(component) {
        let splide = component.querySelector(".splide");
        let splideArrows = component.querySelectorAll(".floorplans-gallery__arrows button");

        if (splide) {
            this.initSplide(splide, splideArrows);
        }
    }

    initSplide(splide, splideArrows) {
        let slider = new Splide(splide, {
            type: 'loop',
            arrows: false,
            pagination: false,
            perPage: 3,
            gap: '2rem',
            breakpoints: {
                960: {
                    gap: '1rem',
                    perPage: 1,
                },
            },
        }).mount();

        splideArrows.forEach(arrow => {
            arrow.addEventListener('click', () => {
                let data = arrow.dataset.direction;
                if (data === "prev") {
                    slider.go("+1");
                }
                if (data === "next") {
                    slider.go("-1");
                }
            });
        });
    }
}
