class Footer {
    constructor(sel) {
        // view
        this.sel = sel;
        this.component = document.querySelector(sel);
        this.instagramSlider = this.component.querySelector('.splide');
        this.formWrapper = this.component.querySelector('.footer-form');
        this.replyCheck = this.component.querySelector('.reply-check');
        this.bookNow = document.querySelector('.bttn--booknow');
        window.initHbsptForm = this.initForm;
        window.onHbsptSent = this.setDefaultInputValues;
        this.colors = [
            '--dark-green',
            '--green',
            '--light-green',
            '--orange',
            '--dark-blue',
            '--light-yellow',
            '--white'
        ];
        this.estiloRoot = document.documentElement.style;

        if (this.component) {
            this.init();
        }
    }

    init() {
        if (this.instagramSlider) this.initSlider();
        window.initHbsptForm = this.initForm;
        this.trackBottomPage();


        gsap.to(this.sel, {
            scrollTrigger: {
                trigger: this.sel,
                start: "top center",
                onEnter: () => {
                    document.body.classList.add("on-footer");
                },
                onLeaveBack: () => {
                    document.body.classList.remove("on-footer");
                }
            }
        });
    }
    async asyncTimeOut(cb, ms) {
        return await new Promise((res) =>
            setTimeout(() => {
                cb();
                res();
            }, ms)
        );
    }
    trackBottomPage = () => {
        window.onscroll = () => {
            const footerTop = this.component.getBoundingClientRect().top;
            const bottomPage = footerTop <= 0;

            return bottomPage
                ? document.body.classList.toggle('bottom-page', true)
                : document.body.classList.toggle('bottom-page', false);
        };
    };
    setDefaultInputValues = () => {
        // this.addressInput?.value = 'none';
        // this.cityInput?.value = 'none';
        // this.phoneSelector?.value = 'No';
        // this.phoneInputNumber?.value = '+54';

        // this.addressInput.removeAttribute('required');
        // this.cityInput.removeAttribute('required');
        // this.phoneSelector.removeAttribute('required');

        this.cityInput?.setAttribute('value', 'none');
        this.addressInput?.setAttribute('value', 'none');
        this.cityInput?.setAttribute('value', 'none');
        this.phoneSelector?.setAttribute('value', 'No');
        this.phoneInputNumber?.setAttribute('value', '+54');
    };
    initForm = (_form) => {
        // console.log(_form);
        const form = _form[0];
        // INIT INPUTS
        this.phoneInput = form.querySelector('.hs-fieldtype-phonenumber');

        this.phoneInputNumber = this.phoneInput?.querySelector('input');
        this.phoneSelector = form?.querySelector(
            '.hs_would_you_like_to_receive_a_reply_via_whatsapp_ select'
        );
        this.addressInput = form.querySelector('.hs_address input');
        this.cityInput = form?.querySelector('.hs_city input');

        // INIT REPLY CHECK
        this.replyCheck = document.querySelector('.reply-check');

        this.setDefaultInputValues();

        if (!this.replyCheck) return;
        this.replyCheck.addEventListener('click', (e) => {
            e.stopPropagation();
            const isActive = this.hasState('active', this.replyCheck);

            this.setState('active', this.replyCheck, !isActive);
            this.setState('active', this.phoneInput, !isActive);

            this.phoneSelector.value = isActive ? 'No' : 'Yes';

            isActive
                ? this.hideNode('active', this.phoneInput)
                : this.showNode('active', this.phoneInput);
        });
    };
    hideNode = async (state, node) => {
        const duration = getComputedStyle(node).getPropertyValue('--_duration');
        console.log(duration);

        this.setState(state, node, false);

        await this.asyncTimeOut(() => {
            node.style.display = 'none';
            console.log(node.style.display);
        }, duration * 1000);
    };
    showNode = async (state, node) => {
        node.style.display = 'block';
        this.asyncTimeOut(() => {
            this.setState(state, node);
        }, 90);
    };
    initSlider() {
        this.instagramSlider = new Splide(this.instagramSlider, {
            type: 'loop',
            arrows: false,
            pagination: false,
            mediaQuery: 'min',
            perPage: 1,
            gap: '0',
            breakpoints: {
                960: {
                    perPage: 6,
                },
            },
        })
        this.instagramSlider.on('move', (i) => {
            this.resetSlidesState();
            this.setActive(i);
        });
        this.instagramSlider.on('mounted', (i) => {
            this.setActive(0);
        });

        this.instagramSlider.mount();

    }
    hasState = (state, node) => node.classList.contains(state);
    resetStates = (state, nodes) => { nodes.forEach((node) => node.classList.toggle(state, false)); };

    setState = (state, node, status) => node.classList.toggle(state, status ?? true);

    setActive(i) {
        const slide = this.instagramSlider.Components.Slides.getAt(i).slide;
        slide.classList.toggle('active', true);
    }
    resetSlidesState() {
        const slides = this.instagramSlider.Components.Slides;
        slides.forEach((component) => {
            component.slide.classList.toggle('active', false);
        });
    }
}
