class GalleryOfThreeVideos {

	constructor(sel) {
		// view
		this.components = document.querySelectorAll(sel);

		if (this.components.length > 0) {
			this.init();
		}
	}

	init() {
		this.components.forEach((component) => {
			const splide = component.querySelector(".splide");
			const itemsSlide = component.querySelectorAll("[data-index]");
			let splideInstance;

			if (splide) {
				splideInstance = new Splide(splide, {
					arrows: false,
					pagination: false,
					direction: 'ttb',
					height: '97.6rem',
					speed: 1200,
					autoplay: true,
					breakpoints: {
						960: {
							destroy: true,
							gap: '1rem',
							perPage: 1,
						},
					},
				});

				splideInstance.on('mounted', () => {
					splideInstance.Components.Slides.getAt(0).slide.classList.add('onActive');
				});
				splideInstance.on('move', (index) => {
					this.updateItem(itemsSlide, index);
					component.querySelectorAll('.splide__slide').forEach(elem => elem.classList.remove('onActive'))
					splideInstance.Components.Slides.getAt(index).slide.classList.add('onActive');
				});

				splideInstance.mount();
			}

			if (itemsSlide) {
				itemsSlide.forEach(item => {
					item.addEventListener('click', () => {
						let targetIndex = parseInt(item.dataset.index);
						splideInstance.go(targetIndex);
					});
				});
			}
		});
	}
	updateItem(itemsSlide, index) {
		let item = itemsSlide[index];
		itemsSlide.forEach(item => item.dataset.state = "no-active");
		item.dataset.state = "active";
	}
}

