class ImageGallery {

	constructor(selector) {
		// view
		this.components = document.querySelectorAll(selector);

		if (this.components.length > 0) {
			this.components.forEach(component => {
				this.init(component);
			});
		}
	}

	init(component) {
		this.component = component;
		this.splide = this.component.querySelector('.splide');

		if (this.component) {
			this.initSlider();
		}
	}

	initSlider() {
		this.slider = new Splide(this.splide, {
			type: 'loop',
			arrows: true,
			pagination: true,
			perPage: 2,
			perMove: 1,
			gap: '2.2rem',
			autoWidth: true,
			focus: 0,
			breakpoints: {
				1440: {
					gap: '1.7rem'
				},
				960: {
					gap: '1.7rem',
					perPage: 1,
					autoWidth: false
				},
			},
		});

		this.slider.on('pagination:mounted', function (data) {
			data.items.forEach(function (item) {
				item.button.insertAdjacentHTML("afterend", "<i class='line'></i>");
			});
		});

		this.slider.mount();
	}

}
