class ParagraphForPricesOrAnnouncements {

    constructor(sel) {
        // view
        this.component = document.querySelector(sel);
        this.splides = this.component.querySelectorAll('.splide');
        this.arraySplides = [];
        this.arraySets = [];
        

        if (this.component) {
            this.init();
        }
    }

    init() {

        if (this.splides.length) {
            let splide = "";
            for (var i = 0; i < this.splides.length; i++) {
                splide = new Splide(this.splides[i], {
                    type: 'fade',
                    arrows: false,
                    pagination: false,
                    perPage: 1,
                    speed: 600,
                    easing: 'ease',
                    rewind: true
                });
                this.arraySplides.push(splide);

                this.arraySplides[i].mount();
            }
        }


        this.timeOutSplides();
        
    }

    generateArrayNumber() {
        let numberOfSplides = this.splides.length;
        let array = [];

        for (let index = 0; index < numberOfSplides; index++) {
            let randomValue = Math.floor(Math.random() * 2);
            array.push(randomValue);
        }
        return array;
    }    
    shuffleArray(array) {
        let currentIndex = array.length, randomIndex, tempValue;
        while (currentIndex !== 0) {
            randomIndex = Math.floor(Math.random() * currentIndex);
            currentIndex--;
            tempValue = array[currentIndex];
            array[currentIndex] = array[randomIndex];
            array[randomIndex] = tempValue;
        }
        return array;
    }
    updateSplides(array) {
        array.forEach((ifnext, i) => {
            if (ifnext) this.arraySplides[i].go('+1');
        });
        
    }
    timeOutSplides() {
        let minOffset = 3000;
        let maxOffset = 10000;
        let time = minOffset;

        let changeInterval = () => {
            this.arraySets = this.generateArrayNumber();
            this.arraySets = this.shuffleArray(this.arraySets);
            this.updateSplides(this.arraySets);
            time = Math.floor(Math.random() * (maxOffset - minOffset + 1) + minOffset);
            clearInterval(intervalId); 
            intervalId = setInterval(changeInterval, time);
        }
        let intervalId = setInterval(changeInterval, time);
    }

}