class Helpers {
	constructor() {}
	static get isHorizontalScroll() {
		return !Helpers.isMobile;
		// return document.body.dataset.scroll === 'x';
	}
	static clamp = (num, min, max) => Math.min(Math.max(num, min), max);
	static lerp = (from, to, interval) => (1 - interval) * from + interval * to;
	static get isMobile() {
		return window.innerWidth < 960;
	}
	static magnitude = (vector) =>
		Math.sqrt(Math.pow(vector.x, 2) + Math.pow(vector.y, 2));
	static normalize = (vector) => {
		const mag = Helpers.magnitude(vector);
		return { x: vector.x / mag, y: vector.y / mag };
	};
	static isInRange = (interval, min, max) => {
		if (interval > min && interval < max) return true;
		return false;
	};
	static getAbsoluteValue = (number) => (number < 0 ? number * -1 : number);
	static viewWidthToPx = (vw) => (vw / 100) * WW;
}

class ScrollTracker {
	constructor(trackNodes, range) {
		this.active = false;
		this._tracking =
			document.querySelectorAll(trackNodes).length > 0
				? document.querySelectorAll(trackNodes)
				: console.warn('No nodes for tracking', trackNodes);
		this.range = range || 0;
		this.timer = null;
	}
	get trackNodes() {
		return this._tracking;
	}
	set trackNodes(nodeselectors) {
		this._tracking = document.querySelectorAll(nodeselectors);
	}
	get closerToView() {
		if (!this.trackNodes) return;
		return Array.from(this.trackNodes).reduce((curr, next) => {
			const currRect = curr.getBoundingClientRect();
			const nextRect = next.getBoundingClientRect();
			let closer;
			if (Helpers.isHorizontalScroll) {
				closer =
					Math.abs(currRect.x) < Math.abs(nextRect.x) ? curr : next;
			} else {
				closer =
					Math.abs(currRect.y) < Math.abs(nextRect.y) ? curr : next;
			}
			return closer;
		});
	}
	track = () => {
		if (!this.trackNodes || !this.active) return;

		const current = Array.from(this.trackNodes)
			.filter((node) => {
				const rect = node.getBoundingClientRect();
				const visibleX =
					Helpers.isHorizontalScroll &&
					Helpers.isInRange(rect.x, this.range * -1, this.range);
				const visibleY =
					!Helpers.isHorizontalScroll &&
					Helpers.isInRange(rect.y, this.range * -1, this.range);

				console.log({ visibleX, visibleY, rect });
				return visibleX || visibleY;
			})
			.pop();
		document.body.dataset.view = '';
		if (!current) return;
		document.body.dataset.view = current.id;
	};
	scrollUp = () => {
		document.body.dataset.direction = 'backward';
		this.track();
	};
	scrollDown = () => {
		document.body.dataset.direction = 'forward';
		this.track();
	};
	scrollHandler = () => {
		if (Helpers.isMobile) return (this.active = false);
		this.active = true;
		if (this.timer !== null) {
			clearTimeout(this.timer);
		}
		this.timer = setTimeout(() => {
			this.active = false;
		}, 150);
	};
	init() {
		this.active = true;
		this.scrollHandler();

		window.addEventListener('scroll', this.scrollHandler);

		const trackLoop = () => {
			window.requestAnimationFrame(() => {
				if (this.active) {
					this.track();
				}
				setTimeout(trackLoop, 15);
			});
		};
		trackLoop();
	}
}
