class SliderHeaderAutoplay {
	constructor(selector) {
		// view
		this.components = document.querySelectorAll(selector);

		if (this.components.length > 0) {
			this.components.forEach(component => {
				this.init(component);
			});
		}
	}

	init(component) {
		this.component = component;
		this.slider = this.component.querySelector('.splide');

		if (this.component) {
			this.initSlider();
		}
	}

	initSlider() {
		let autoplaySpeed = WW > 961 ? 1.5 : 0.5;

		this.slider = new Splide(this.slider, {
			type: 'loop',
			arrows: false,
			pagination: false,
			perPage: 1,
			gap: '2rem',
			autoWidth: true,
			autoScroll: {
				speed: autoplaySpeed,
				pauseOnHover: false,
			},
			breakpoints: {
				960: {
					autoplay: false,
					type: 'slide',
					autoWidth: false,
					gap: '1.3rem',
				},
			},
		}).mount(window.splide.Extensions);

		this.setActive(0);

		this.slider.on('move', (i, prev, dest) => {
			this.resetSlidesState();
			this.setActive(i);
		});
	}

	setActive(i) {
		const slide = this.slider.Components.Slides.getAt(i).slide;
		slide.classList.toggle('active', true);
	}

	resetSlidesState() {
		const slides = this.slider.Components.Slides;
		slides.forEach((component) => {
			component.slide.classList.toggle('active', false);
		});
	}
}
