class ThreeImagesLightbox {
	constructor(selector) {
		// view
		this.components = document.querySelectorAll(selector);

		if (this.components.length > 0) {
			this.components.forEach(component => {
				this.init(component);
			});
		}
	}

	init(component) {
		this.component = component;
		this.images = this.component.querySelectorAll('[data-comp="openLightbox"]');

		if (this.component) {
			this.initLightbox();
		}
	}

	initLightbox() {
		if (this.images) {
			this.images.forEach(img => {
				img.addEventListener('click', () => {
					this.createLightbox(img);
				});
			});
		}

		document.body.addEventListener('click', (e) => {
			if (e.target.matches('.three-images-lightbox--lightbox .row') || e.target.matches('.three-images-lightbox--lightbox .img-box') || e.target.matches('.three-images-lightbox--lightbox .text')) {
				e.stopPropagation();
			}
			if (e.target.matches('.three-images-lightbox--lightbox') || e.target.matches('[data-comp="closeLightbox"]')) {
				this.closeLightbox();
			}
		});

		document.body.addEventListener("keyup", (e) => {
			if (e.key === "Escape") {
				this.closeLightbox();
			}
		});
	}

	createLightbox(img) {
		let image = img.querySelector('img');
		let text = img.querySelector('.txt-box');
		let html = '';
		html += '<section data-lenis-prevent class="container three-images-lightbox--lightbox">';
		html += '<div class="row middle">';
		html += '<article class="col-12-6 no-mobile image">';
		html += '<figure class="img-box">';
		html += image.outerHTML;
		html += '</figure>';
		html += '</article>';
		html += '<article class="col-12-6 text">';
		html += '<button data-comp="closeLightbox">Close</button>';
		if (text) {
			html += text.outerHTML;
		}
		html += '</article>';
		html += '</div>';
		html += '</section>';
		document.body.insertAdjacentHTML("beforeend", html);
		document.body.setAttribute('data-three-images-lightbox', 'opened')
		setTimeout(() => {
			document.body.querySelector('.three-images-lightbox--lightbox').classList.add('show');
		}, 100)
	}

	closeLightbox() {
		document.body.querySelector('.three-images-lightbox--lightbox').classList.remove('show');
		document.body.removeAttribute('data-three-images-lightbox');
		setTimeout(() => {
			document.body.querySelector('.three-images-lightbox--lightbox').remove();
		}, 400)
	}
}

