class VideoWithCoverTextWithControlsAndAudio {

	constructor(sel) {

		if( WW > 961) return;

		// view
		this.component = document.querySelector(sel);
		this.bttnVideo = this.component.querySelector('[data-bttn="play-video"] button');
		this.video = this.component.querySelector('video');
		

		if (this.component) {
			this.init();
		}
	}

	init() { 
		
		this.bttnVideo?.addEventListener('click', (e) => {
			e.preventDefault();
			this.component.dataset.state == 'paused' ? this.playVideo() : this.pauseVideo();
		});
		this.video?.addEventListener('pause', () => {
			this.pauseVideo();
		});

	}

	playVideo() {
		this.component.dataset.state = 'playing';
		this.video.muted = false;
		this.video.play();
		this.bttnVideo.textContent = "Pause";
	}
	pauseVideo() {
		this.component.dataset.state = 'paused';
		this.video.muted = true;
		this.video.pause();
		this.bttnVideo.textContent = "Play";
	}

}