<?php
get_header();

?>
<section class="container villas-have-fun" data-comp="villas-have-fun">
    <section class="container">
        <div class="row top villas-have-fun__row">
            <?php
            $CategoryPosts = new WP_Query(array(
                'numberposts'    => -1,
                'post_type'        => 'villas',
                'tax_query' => array(
                    array(
                        'taxonomy' => 'villas_type',
                        'field' => 'term_id',
                        'terms' => get_queried_object()->term_id,
                    )
                )
            ));
            if ($CategoryPosts->have_posts()) {
                while ($CategoryPosts->have_posts()) {
                    $CategoryPosts->the_post();
            ?>
                    <article class="villas-have-fun__item <?= get_field('cards_size'); ?> <?= get_field('desktop_position'); ?> <?= get_field('mobile_position'); ?>">
                        <a href="<?= get_permalink(); ?>">
                            <figure class="img-box">
                                <?= wp_get_attachment_image(get_field('card_image'), 'full'); ?>
                            </figure>
                            <div class="description">
                                <h3><?= the_title(); ?></h3>
                                <?php
                                $list = explode(PHP_EOL, get_field('information'));

                                if ($list && is_array($list)) {
                                    echo '<ul>';
                                    foreach ($list as $item) {
                                ?>
                                        <li><?= $item; ?></li>
                                <?php
                                    }
                                    echo '</ul>';
                                }
                                ?>
                                <span class="text-mobile mobile">Explore</span>
                            </div>
                        </a>
                    </article>
            <?php
                }
                wp_reset_postdata();
            }
            ?>
        </div>
    </section>
</section>
<!-- Have fun filter -->
<nav class="container have-fun-filter-back" data-comp="have-fun-filter-back">
    <div class="row">
        <div class="col-12-12 center">
            <!-- Select -->
            <div class="have-fun-filter-back__select">
                <a href="<?= get_permalink(727); ?>" class="text"><i class="icon-arrow-left"></i><em>back</em></a>
                <span class="category"><?= get_queried_object()->name; ?></span>
            </div>
        </div>
    </div>
</nav>
<!-- /Have fun filter -->
<?php

get_footer();
?>